package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安服务公司跨区经营基本信息上报 实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "sb_crosscompany")
public class Bafwgskqjyxx extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select companyCode from security_company sc where sc.user_id = t1.userid and sc.active)", isSubQuery = true)
    private String bagsbm;
    /**
     * 经营地省市区（县）
     */
    @MinisterialAttr(column = "manageraddress")
    private String jydz;
    /**
     * 联系方式
     */
    @MinisterialAttr(column = "Chargephone")
    private String lxfs;
    /**
     * 保安服务类型
     */
    private String fwlx;
    /**
     * 负责人公民身份号码
     */
    @MinisterialAttr(column = "Chargecardnumber")
    private String fzrsfzh;
    /**
     * 负责人姓名
     */
    @MinisterialAttr(column = "Chargename")
    private String fzrxm;
    /**
     * 负责人职务
     */
    @MinisterialAttr(column = "Chargepost")
    private String fzrzw;
    /**
     * 负责人联系电话
     */
    @MinisterialAttr(column = "Chargephone")
    private String fzrdh;
    /**
     * 备案公安机关编码
     */
    private String bajgbm;
    /**
     * 备案公安机关名称
     */
    private String bajgmc;
    /**
     * 备案日期
     */
    private String barq;
    /**
     * 开始经营日期
     */
    private String ksjyrq;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;
    /**
     * 保安服务许可证号
     */
    @MinisterialAttr(column = "Licencenum")
    private String bafwxkz;

}
