package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安服务公司分公司主要管理人员信息上报实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "sb_management_info", extraWhere = "and t1.user_id in (select security_company.user_id from security_company where institutionType = '0105')")
public class Bafwgsfgsglry extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select companyCode from security_company where security_company.active = TRUE and security_company.USER_ID = t1.user_id)", isSubQuery = true)
    private String bagsbm;
    /**
     * 分公司名称
     */
    @MinisterialAttr(column = "(select `name` from security_company where security_company.active = TRUE and security_company.USER_ID = t1.user_id)", isSubQuery = true)
    private String fgsmc;
    /**
     * 公民身份号码
     */
    @MinisterialAttr(column = "manager_id")
    private String sfzh;
    /**
     * 姓名
     */
    @MinisterialAttr(column = "`name`")
    private String xm;
    /**
     * 联系电话
     */
    @MinisterialAttr(column = "phone")
    private String lxdh;
    /**
     * 备案公安机关编码
     */
    private String bagajgbm;
    /**
     * 备案公安机关名称
     */
    private String bagajgmc;
    /**
     * 备案日期
     */
    private String barq;
    /**
     * 职务
     */
    private String zw;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    /**
     * 证件类型
     */
    @MinisterialAttr(column = "ifnull(manager_license_type,1)", isSubQuery = true, DATA_FORMAT = MinisterialDataFormat.CARD_TYPE)
    private String zjlx;

    /**
     * 总公司保安服务许可证号
     */
    @MinisterialAttr(column = "(select sc2.public_security_license_number from security_company sc2 where sc2.active = TRUE and sc2.USER_ID = t1.user_id)", isSubQuery = true)
    private String bafwxkz;


}
