package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 *保安从业单位及保安培训机构监督检查情况
 * @author Ethan
 */
@Data
@MinisterialEntity(tableName = "company_inspection")
public class Badwjdjcxx extends XxbaBaseDto {

	/**
	 * 被检查单位类别
	 */
	@MinisterialAttr(column = "institutionType", DATA_FORMAT = MinisterialDataFormat.INSTITUTION_TYPE)
	private String jclx;

	/**
	 * 检查日期
	 */
	@MinisterialAttr(column = "check_date", DATE_FORMAT = "%Y%m%d")
	private String jcrq;

	/**
	 * 检查内容
	 */
	@MinisterialAttr(column = "content")
	private String jcnr;

	/**
	 * 保安服务公司编码
	 */
	@MinisterialAttr(column = "(select companyCode from security_company sc where sc.active and sc.user_id = t1.userid)", isSubQuery = true)
	private String bagsbm;

	/**
	 * 自行招用保安员的单位编码
	 */
	private String dwbm;

	/**
	 * 保安培训机构编码
	 */
	private String pxdwbm;

	/**
	 * 检查公安机关编码
	 */
	private String jcdwbm;

	/**
	 * 检查公安机关名称
	 */
	private String jcdwmc;

	/**
	 * 备注1
	 */
	private String bz1;

	/**
	 * 备注2
	 */
	private String bz2;

	/**
	 * 发现问题
	 */
	private String jcjl;

	/***
	 * 处理结果
	 */
	private String cljg;

	/***
	 * 检查人员
	 */
	private String jcr;

	/***
	 * 主要检查人员身份号码
	 */
	private String sfzh;

	/***
	 * 检查类别
	 */
	@MinisterialAttr(column = "\"1\"", isSubQuery = true)
	private String jclb;


	/***
	 * 罚款金额
	 */
	private String fkje;


	/***
	 * 没收违法所得金额
	 */
	private String mswfsdje;


}
