package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安服务公司枪支配备情况基本信息
 *
 * @author llc
 */
@Data
@MinisterialEntity(tableName = "sb_firearms")
public class Bacydwqzpbxx extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select companyCode from security_company sc where sc.user_id = t1.USERID and sc.active)", isSubQuery = true)
    private String bagsbm;
    /**
     * 公务用枪枪证编号
     */
    private String qzbh;
    /**
     * 枪号
     */
    @MinisterialAttr(column = "firearmsnum")
    private String qh;
    /**
     * 制造企业名称
     */
    @MinisterialAttr(column = "firearmscompany")
    private String zzqymc;
    /**
     * 发证单位名称
     */
    @MinisterialAttr(column = "firearmcertification")
    private String fzdwmc;
    /**
     * 发证日期
     */
    private String fzrq;
    /**
     * 枪支注销原因
     */
    private String zxyy;
    /**
     * 枪支注销日期
     */
    private String zxrq;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;

    @Override
    public String toString() {
        return "Bacydwqzpbxx{" +
                "bagsbm='" + bagsbm + '\'' +
                ", qzbh='" + qzbh + '\'' +
                ", qh='" + qh + '\'' +
                ", zzqymc='" + zzqymc + '\'' +
                ", fzdwmc='" + fzdwmc + '\'' +
                ", fzrq=" + fzrq +
                ", zxyy='" + zxyy + '\'' +
                ", zxrq='" + zxrq + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
