package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * 服务范围转换
 * @author linqinglin
 * @date 2021/03/09 0009 16:51
 */
public class SecurityScopeTypeFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        Map<String,String> scopeTypeMap = new HashMap<>();
        scopeTypeMap.put("1","10");//门卫
        scopeTypeMap.put("2","20");//巡逻
        scopeTypeMap.put("3","30");//守护
        scopeTypeMap.put("4","50");//随身护卫
        scopeTypeMap.put("6","40");//押运
        scopeTypeMap.put("7","60");//安全检查
        scopeTypeMap.put("8","80");//安全风险评估
        scopeTypeMap.put("9","70");//安全技术防范
        scopeTypeMap.put("10","90");//区域秩序维护


        String result = "";

        String[] scopeTypes = data.toString().split(",");
        for (String scopeType : scopeTypes) {
            if(scopeTypeMap.get(scopeType) != null){
                result =scopeTypeMap.get(scopeType)+ " ";
            }
        }

        if(result.length() > 0){
            result = result.substring(0,result.length()-1);
        }
        return result;
    }
}
