package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.google.common.collect.Maps;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * 证件类型
 * @author zhangyutong
 */
public class CardTypeMinDataFormatStrategy implements MinDataFormatStrategy{
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        Map<String,String> cardTypes = Maps.newHashMapWithExpectedSize(10);
        // 身份证
        cardTypes.put("1","111");
        // 中国人民解放军军官证
        cardTypes.put("2","114");
        // 中国人民武装警察警官证
        cardTypes.put("3","115");
        // 香港特区护照/身份证明
        cardTypes.put("4","420");
        // 澳门特区护照/身份证明
        cardTypes.put("5","421");
        // 台湾居民来往大陆通行证
        cardTypes.put("6","511");
        // 外国人护照
        cardTypes.put("8","414");
        return cardTypes.get(String.valueOf(data));
    }
}
