package com.bcxin.ars.model.task;

import java.io.Serializable;

import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 安保任务人员排班明细
 * @author Ethan
 */
public class TaskPersonScheduleDetail implements Serializable {

	private static final long serialVersionUID = -6488198756255430705L;

	private Long id;
	
	/**
	 * 区域编号
	 */
	private Long nativeCode;
	
	/**
	 * 人员排班ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long personScheduleId;
	
	/**
	 * 班次ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long scheduleId;
	
	/**
	 * 班次
	 */
	private SecurityCompanySchedule schedule;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Long getPersonScheduleId() {
		return personScheduleId;
	}

	public void setPersonScheduleId(Long personScheduleId) {
		this.personScheduleId = personScheduleId;
	}

	public Long getScheduleId() {
		return scheduleId;
	}

	public void setScheduleId(Long scheduleId) {
		this.scheduleId = scheduleId;
	}

	public SecurityCompanySchedule getSchedule() {
		return schedule;
	}

	public void setSchedule(SecurityCompanySchedule schedule) {
		this.schedule = schedule;
	}
	
}
