package com.bcxin.ars.model.task;


import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import java.util.Date;

/**
 * 任务打卡记录
 *
 * @author yyx
 * @Date 2020-03-26 09:39:54
 */
@Data
public class PerTaskCardRecord extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 任务打卡记录ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long taskCardRecordId;
    /**
    * 设置的打卡时间
    * 
    */
    private Date setClockInTime;
    /**
    * 打卡日期
    * 
    */
    private Date clockInDate;
    /**
    * 打卡时间
    * 
    */
    private Date clockInTime;
    /**
    * 打卡类别(上班打卡、下班打卡)
    * 
    */
    private String clockInType;
    /**
    * 第几轮打卡
    * 
    */
    private Integer clockInRound;
    /**
    * 打卡地点经度
    * 
    */
    private String placeLongitude;
    /**
    * 打卡地点纬度
    * 
    */
    private String palceLatitude;
    /**
    * 打卡方式(wifi打卡、地点打卡)
    * 
    */
    private String clockInWay;
    /**
    * 打卡地点
    * 
    */
    private String attendAddress;
    /**
    * 考勤状态
    * 
    */
    private String attendStatus;
    /**
    * 所在企业ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;
    /**
    * 班次ID
    *
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long shiftId;
    /**
    * 班次规则ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long shiftRuleId;
    /**
    * 考勤WIFIID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long attendWifiId;
    /**
    * 打卡人员ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;
    /**
    * 审批申请ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long approveApplyId;
    /**
    * 备注
    * 
    */
    private String remark;
    /**
    * 任务ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comTaskId;
         
 	
    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}