package com.bcxin.ars.model.task;


import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.Date;

/**
 * 任务排班制明细
 *
 * @author linqinglin
 * @Date 2020-03-24 16:43:05
 */
@Data
public class ComTaskSchedul extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 任务排班制ID
    * 
    */
    private Long taskSchedulId;
    /**
    * 企业ID
    * 
    */
    private Long comId;
    /**
    * 排班日期
    * 
    */
    private Date schedulDate;
    /**
    * 是否休息
    * 
    */
    private String isRest;
    /**
    * 任务ID
    * 
    */
    private Long comTaskId;
    /**
    * 排班人员ID
    * 
    */
    private Long perId;
    /**
    * 班次ID
    * 
    */
    private Long shiftId;


    @Override
    public boolean equals (Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            ComTaskSchedul that = (ComTaskSchedul) o;
            if (that.getTaskSchedulId() != null && this.getTaskSchedulId() != null){
                if (that.getTaskSchedulId().intValue() == this.getTaskSchedulId().intValue()
                        && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}