package com.bcxin.ars.model.task;

import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import java.util.Date;

/**
 * 企业班次
 *
 * @author yyx
 * @Date 2020-03-26 09:39:32
 */
@Data
public class ComShift extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 班次ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long shiftId;
    /**
    * 是否逻辑删除
    * 
    */
    private String isDelete;
    /**
    * 班次名称
    * 
    */
    private String shiftName;
    /**
    * 班次规则详情
    * 
    */
    private String shiftRuleDetail;
    /**
    * 班次类型
    * 
    */
    private String shiftType;
    /**
    * 生效规则
    * 
    */
    private String effectRule;
    /**
    * 生效开始时间
    * 
    */
    private Date effectStartTime;
    /**
    * 生效截止时间
    * 
    */
    private Date effectEndTime;
    /**
    * 每天上下班次数
    * 
    */
    private Integer commutTimes;
    /**
    * 允许迟到时间上限
    * 
    */
    private Integer permitLateUp;
    /**
    * 严重迟到时间下限
    * 
    */
    private Integer seriousLateLow;
    /**
    * 旷工时间下限
    * 
    */
    private Integer absentLow;
    /**
    * 打卡时限上限
    * 
    */
    private Integer clockWorkLimit;
    /**
    * 允许迟到校验开关
    * 
    */
    private String permitLateSwitch;
    /**
    * 严重迟到校验开关
    * 
    */
    private String seriousLateSwitch;
    /**
    * 旷工校验开关
    * 
    */
    private String absentSwitch;
    /**
    * 打卡时限开关
    * 
    */
    private String clockLimitSwitch;
    /**
    * 企业ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

 	
    @Override
    public boolean equals (Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            ComShift that = (ComShift) o;
            if (that.getShiftId() != null && this.getShiftId() != null){
                if (that.getShiftId().intValue() == this.getShiftId().intValue()
                        && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

}