package com.bcxin.ars.model.sys;


import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * 第三方对接信息
 *
 * @author linqinglin
 * @Date 2020-05-15 10:14:15
 */
@Data
public class ThirdParty extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 名称
    * 
    */
    private String name;

    /**
     * 秘钥
     */
    private String clientSecret;

    /**
     * 公司id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;


    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}