package com.bcxin.ars.model.sys;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;

/**
 * @author  wjb
 * @date 2018年8月16日17:49:21
 * @desc 编码表 sys_dict 所对应的实体类
 */
@Data
public class Sysdict extends BaseModel {
    /**
     * 代码条目ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ModelAnnotation(column ="sysDictId",getName = "代码Id")
    private Long sysDictId;

    /**
     * '代码类型'
     */
    @ModelAnnotation(isGrid = true,column ="codeType",getName = "代码类型",width = "200px")
    private String codeType;

    /**
     * 代码所在表,NULL表示通用(因为存在同一个code在不同表值相同但含义不同的情况
     */
    @ModelAnnotation(column ="tableName",getName = "代码所在表")
    private String tableName;

    /**
     * 代码中文描述
     */
    @ModelAnnotation(isGrid = true,column ="description",getName = "代码中文描述",width = "200px")
    private String description;

    /**
     * 代码值
     */
    @ModelAnnotation(isGrid = true,column ="codeValue",getName = "代码值",width = "150px")
    private String codeValue;

    /**
     * 代码值中文描述
     */
    @ModelAnnotation(isGrid = true,column ="label",getName = "代码值中文描述",width = "200px")
    private String label;

    /**
     * '是否有效'
     */
    @ModelAnnotation(isGrid = true,column ="isActive",getName = "是否有效")
    private String isActive;

    /**
     * '排序'
     */
    @ModelAnnotation(isGrid = true,column ="seq",getName = "排序")
    private Integer seq;

}