package com.bcxin.ars.model.sys;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/**
 * @author  yyx
 * @date 2020-05-18
 * @desc 导入配置表
 */
@Data
public class ImportConfig  extends BaseModel {
    /**
     * 开始读取的行数
     */
    @ModelAnnotation(isGrid = true,column ="readRow",getName = "开始读取的行数",width = "90px")
    private Integer readRow;
    /**
     * 读取唯一标识列
     */
    @ModelAnnotation(isGrid = true,column ="keyColumn",getName = "读取唯一标识列",width = "90px")
    private Integer keyColumn;
    /**
     * 读取结果列
     */
    @ModelAnnotation(isGrid = true,column ="resultColumn",getName = "读取结果列",width = "90px")
    private Integer resultColumn;
    /**
     * 读取原因列
     */
    @ModelAnnotation(isGrid = true,column ="reasonColumn",getName = "读取原因列",width = "90px")
    private Integer reasonColumn;
    /**
     * 比对业务类型
     */
    @ModelAnnotation(isGrid = true,column ="businessType",getName = "比对业务类型",width = "200px",dictName = "comparisonBusinessType")
    private String businessType;
    /**
     * 表名
     */
    @ModelAnnotation(isGrid = true,column ="tableName",getName = "表名",width = "200px")
    private String tableName;
    /**
     * 字段名
     */
    @ModelAnnotation(isGrid = true,column ="filedName",getName = "字段名",width = "180px")
    private String filedName;
    /**
     * 原因字段名
     */
    @ModelAnnotation(isGrid = true,column ="reasonFiledName",getName = "原因字段名",width = "180px")
    private String reasonFiledName;
    /**
     * 状态字段名
     */
    @ModelAnnotation(isGrid = true,column ="resultFiledName",getName = "状态字段名",width = "180px")
    private String resultFiledName;
    /**
     * 补贴证书类型
     */
    @ModelAnnotation(isGrid = true,column ="subsidyCerType",getName = "补贴证书类型",width = "100px")
    private String subsidyCerType;

}
