package com.bcxin.ars.model.sys;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/***
 * 导出配置信息表
 * @author subh
 */
@Data
public class ExportConfig extends BaseModel  {
    /**
     * 标题
     */
    @ModelAnnotation(isGrid = true,column ="title",getName = "标题",width = "500px")
    private String title;
    /**
     * 导出类型
     */
    @ModelAnnotation(isGrid = true,column ="exportType",getName = "导出类型",width = "150px",dictName = "exportType")
    private String exportType;
    /**
     * 列数，不包含序号
     */
    @ModelAnnotation(isGrid = true,column ="columns",getName = "列数",width = "50px")
    private Integer columns;
    /***
     * 是否有序号列
     */
    @ModelAnnotation(isGrid = true,column ="columnNo",getName = "是否有序号列",width = "80px")
    private String columnNo;
    /***
     * 是否打为jar包
     */
    @ModelAnnotation(isGrid = true,column ="isJar",getName = "是否打为jar包",width = "80px")
    private String isJar;
    /***
     * 查询数据的表名
     */
    @ModelAnnotation(isGrid = true,column ="tableName",getName = "表名",width = "200px")
    private String tableName;
    /**
     * 补贴证书类型
     */
    private String subsidyCerType;
    /**
     * 花名册区分表名的key
     */
    @ModelAnnotation(isGrid = true,column ="trainNameKey",getName = "花名册区分表名的key",width = "150px")
    private String trainNameKey;

}
