package com.bcxin.ars.model.sys;


import com.abcxin.smart.validator.annotation.CardNumber;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 银行账号信息
 *
 * @author linqinglin
 * @Date 2020-05-13 14:37:13
 */
@Data
public class BankAccount extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 姓名
    * 
    */
    @NotBlank(message = "姓名不能为空")
    private String name;
    /**
    * 身份证
    * 
    */
    @CardNumber(message = "身份证格式不符")
    private String idNum;
    /**
    * 卡号
    * 
    */
    @NotBlank(message = "卡号不能为空")
    private String carNo;
    /**
    * 开户行号
    * 
    */
    @NotBlank(message = "开户行号不能为空")
    private String bankNo;
    /**
    * 开户行名称
    * 
    */
    @NotBlank(message = "开户行名称不能为空")
    private String bankName;
    /**
    * 卡号状态（1正常、2已销卡）
    * 
    */
    @NotBlank(message = "卡号状态不能为空")
    private String state;

    /**
     *  是否初始 0非初始（已激活） 1是初始（未激活）
     */
    @NotBlank(message = "激活状态不能为空")
    private String initial;
    /**
    * 激活时间
    * 
    */
    private String activeDate;
    /**
    * 开卡时间
    *
    */
    @NotBlank(message = "开卡时间不能为空")
    private String cardDate;
    /**
    * 冻结时间
    * 
    */
    private String freezeDate;
    /**
    * 冻结原因
    * 
    */
    private String reason;

    /**
     * 是否已推送saas
     */
    private Boolean push;

    /**
     *账户类型 编码值 ，0为I类卡，1为II类卡
     */
    @NotBlank(message = "账户类型不能为空")
    private String bankAccountType;

    private String perId;
}