package com.bcxin.ars.model.sx;

import lombok.Data;

import java.util.Date;
@Data
public class StepProc {
    /** 主键，具体数据的唯一ID，中间库表之间数据的关联 */
    private String orgbusno;

    /** 主键，详见附录2.3 */
    private String projid;

    /** 主键，默认为1，用于重报数据的情况。 */
    private String dataver;

    /** 主键，审批过程序号 */
    private Integer sn;

    /** 投资项目并联相关，非投资项目并联事项可空 */
    private String project_code;

    /** 事项所属行政区划，编码规则见附录2.4 */
    private String itemregionid;

    /** 环节名称 */
    private String nodename;

    /** 记录环节的批次信息 */
    private String nodecode;

    /** 1-开始环节；2-中间环节；3-结束环节；4-只有一条审批数据（开始既是结束 */
    private String nodetype;

    /** 环节处理人编号 */
    private String nodeprocer;

    /** 环节处理人姓名 */
    private String nodeprocername;

    /** 编码规则见附录2.4 */
    private String nodeprocerarea;

    /** 编码规则见附录2.4 */
    private String region_id;

    /** GB 32100-2015中统一社会信用代码 */
    private String procunit;

    /** GB/T 19488.2-2008中机构名称。 */
    private String procunitname;

    /** 1-待办，2-已办 */
    private String nodestate;

    /** 环节开始时间 */
    private Date nodestarttime;

    /** 如果没有结束时间，则填写开始时间 */
    private Date nodeendtime;

    /** 环节处理意见 */
    private String nodeadv;

    /** 环节承诺时限 */
    private Short timelimit;

    /** 环节承诺时限单位 1-工作日；2-自然日；3-小时；4-分钟；5-月（可空） */
    private Byte promisetimeunit;

    /** 0 - 不同意，1 - 同意 ，2-不受理，3-不予受理，4-受理，5-补齐补正，6-特别程序（挂起操作），7-退回  */
    private String noderesult;

    /** 这里取环节开始时间 */
    private Date occurtime;

    /** 进入数据库时间，默认为系统时间 */
    private Date maketime;

    /** 数据交换状态标志位，默认为0 */
    private Long signstate;

    /**  */
    private String errorcode1;

    /**  */
    private String errormsg1;

    /**  */
    private String status1;

    /** 由于存在同一事项多系统办理的情况，需要明确数据来源具体系统 */
    private String sysmark;

    /**  */
    private Date localtime;

    /** 同步类型 */
    private String cd_operation;

    /** 业务动作 */
    private String eventname;

}