package com.bcxin.ars.model.subsidy;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;
import java.util.Date;

@Data
public class GradeSubsidyRoster extends BaseModel {

    /**
     * 是否在批次审批中
     */
    private String used;

    /**
     * 状态
     */
    @ModelAnnotation(isGrid = true,column ="subsidyStatus",needTranslate = true,getName = "状态",width = "100px",dictName = "compareStatus")
    private String subsidyStatus;
    /**
     * 姓名
     */
    @ModelAnnotation(isGrid = true,column ="name",getName = "姓名",width = "100px")
    private String name;
    /**
     * 身份证号
     */
    @ModelAnnotation(isGrid = true,column ="idNum",getName = "身份证号",width = "160px")
    private String idNum;
    /**
     * 手机号
     */
    @ModelAnnotation(isGrid = true,column ="phone",getName = "手机号",width = "120px")
    private String phone;
    /**
     * 补贴证书类型
     */
    private String subsidyCerType;
    /**
     * 性别
     */
    private String sex;

    /**
     * 报名id
     */
    private Long gradeId;

    /**
     * 批次id
     */
    private Long batchId;

    /**
     * 公安机关id
     */
    private Long orgId;
    /**
     * 公安机关名称
     */
    private String orgName;
    /**
     * 培训机构id
     *
     */
    private Long trainId;
    /**
     * 培训机构
     *
     */
    private String trainName;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 户籍性质
     */
    private String residentNature;
    /**
     * 户籍所在地
     */
    private String residentPlace;
    /**
     * 劳动合同起始时间
     */
    private Date contractStartTime;
    /**
     * 劳动合同结束时间
     */
    private Date contractEndTime;
    /**
     * 补贴政策类型
     */
    private String subsidyType;
    /**
     * 补贴对象类型（企业、培训机构）
     */
    private String subsidyPeopleType;
    /**
     * 统一社会信用代码
     */
    private String socialCode;
    /**
     * 培训职业（工种）或项目
     */
    private String trainProfession;
    /**
     * 培训等级（一级、二级、三级、四级、五级、非等级）
     */
    private String trainGrade;
    /**
     *  培训课时
     */
    private String classHour;
    /**
     * 培训开始时间
     */
    private Date trainBeginDate;
    /**
     * 培训结束时间
     */
    private Date trainEndDate;
    /**
     *  补贴金额
     */
    @ModelAnnotation(isGrid = true,column ="subsidyMoney",getName = "可补贴金额（元）",width = "150px")
    private String subsidyMoney;
    /**
     *  补贴金额比例
     */
    private String subsidyMoneyRate;
    /**
     *证书类型
     */
    @ModelAnnotation(isGrid = true,column ="certificateType",getName = "证书类型",width = "140px")
    private String certificateType;
    /**
     * 证书编号
     */
    @ModelAnnotation(isGrid = true,column ="certificateNumber",getName = "证书编号",width = "150px")
    private String certificateNumber;
    /**
     * 发证时间
     */
    @ModelAnnotation(isGrid = true,column ="certificateDate",getName = "发证时间",width = "120px")
    private String certificateDate;
    /**
     * 证书职业工种
     */
    private String certificateProfession;
    /**
     * 证书等级（一级、二级、三级、四级、五级、非等级）
     */
    private String certificateGrade;
    /**
     *  结业补贴金额
     */
    private String completeMoney;
    /**
     *  结业补贴金额比例
     */
    private String completeMoneyRate;
    /**
     *  鉴定补贴金额
     */
    private String appraisalMoney;
    /**
     *  鉴定补贴金额比例
     */
    private String appraisalMoneyRate;
    /**
     * 备注
     */
    private String remark;
    /**
     *  原因
     */
    @ModelAnnotation(isGrid = true,column ="reason",getName = "不可申请原因",width = "100px")
    private String reason;

    /**
     * 结业证书编号
     *
     */
    private String completeCerNo;

    /**
     * 结业发证日期
     *
     */
    private String completeCerDate;

    /**
     * 鉴定发证日期
     *
     */
    private String cerDate;
    /**
     * 鉴定证书编号
     *
     */
    private String cerNo;

    /**
     * 是否参加鉴定考试
     */
    private Boolean inAppraisal;

    private String qrcode;

    /**
     * 平台补贴服务费
     */
    private String platSerFee;

    private Long cerId;

    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
