package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.User;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 保安服务公司保险信息信息
 */
public class YearReportInsurance extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	@ModelAnnotation(getName="年报ID",column = "yearReportId")
	private Long yearReportId;
	
	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;

	/**
	 * 保安公司ID
	 */

	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ModelAnnotation(getName="保安公司ID",column = "company_id")
	private Long company_id;

	/**
	 * 保险公司名称
	 */
	@ModelAnnotation(getName="保险公司名称",column = "insurance_company")
	private String insurance_company;

	/**
	 * 在保人数
	 */
	@ModelAnnotation(getName="在保人数",column = "insured_num")
	private String insured_num;

	/**
	 * 起保日期
	 */
	@ModelAnnotation(getName="起保日期",column = "protection_date")
	private String protection_date;

	/**
	 * 保险产品名称
	 */
	@ModelAnnotation(getName="保险产品名称",column = "insurance_product")
	private String insurance_product;

	/**
	 * 每人保费
	 */
	@ModelAnnotation(getName="每人保费",column = "premium_person")
	private String premium_person;


	/**
	 * 意外身故/伤残
	 */
	@ModelAnnotation(getName="意外身故/伤残",column = "ywsg")
	private String ywsg;


	/**
	 * 交通意外
	 */
	@ModelAnnotation(getName="交通意外",column = "jtyw")
	private String jtyw;


	/***
	 * 意外医疗
	 */
	@ModelAnnotation(getName="意外医疗",column = "ywyl")
	private String ywyl;


	/***
	 * 重大疾病
	 */
	@ModelAnnotation(getName="重大疾病",column = "zdcj")
	private String zdcj;


	/***
	 * 住院津贴
	 */
	@ModelAnnotation(getName="住院津贴",column = "jyjt")
	private String jyjt;


	/**
	 * 法院费用
	 */
	@ModelAnnotation(getName="法院费用",column = "flfy")
	private  String flfy;

	/**
	 * 结束日期
	 */
	@ModelAnnotation(getName="结束日期",column = "end_date")
	private String end_date;
	/**
	 * 保单号
	 */
	@ModelAnnotation(getName="保单号",column = "insurance_number")
	private  String insurance_number;

	/**
	 * 保单图片
	 */
	@ModelAnnotation(getName="保单图片",column = "insurance_pic")
	private  String insurance_pic;


	public String getYwsg() {
		return ywsg;
	}

	public void setYwsg(String ywsg) {
		this.ywsg = ywsg;
	}

	public String getJtyw() {
		return jtyw;
	}

	public void setJtyw(String jtyw) {
		this.jtyw = jtyw;
	}

	public String getYwyl() {
		return ywyl;
	}

	public void setYwyl(String ywyl) {
		this.ywyl = ywyl;
	}

	public String getZdcj() {
		return zdcj;
	}

	public void setZdcj(String zdcj) {
		this.zdcj = zdcj;
	}

	public String getJyjt() {
		return jyjt;
	}

	public void setJyjt(String jyjt) {
		this.jyjt = jyjt;
	}

	public String getFlfy() {
		return flfy;
	}

	public void setFlfy(String flfy) {
		this.flfy = flfy;
	}

	public String getEnd_date() {
		return end_date;
	}

	public void setEnd_date(String end_date) {
		this.end_date = end_date;
	}

	public String getInsurance_number() {
		return insurance_number;
	}

	public void setInsurance_number(String insurance_number) {
		this.insurance_number = insurance_number;
	}

	public String getInsurance_pic() {
		return insurance_pic;
	}

	public void setInsurance_pic(String insurance_pic) {
		this.insurance_pic = insurance_pic;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}


	public String getInsurance_company() {
		return insurance_company;
	}

	public void setInsurance_company(String insurance_company) {
		this.insurance_company = insurance_company;
	}


	public String getProtection_date() {
		return protection_date;
	}

	public void setProtection_date(String protection_date) {
		this.protection_date = protection_date;
	}

	public String getInsurance_product() {
		return insurance_product;
	}

	public void setInsurance_product(String insurance_product) {
		this.insurance_product = insurance_product;
	}

	public Long getCompany_id() {
		return company_id;
	}

	public void setCompany_id(Long company_id) {
		this.company_id = company_id;
	}

	public String getInsured_num() {
		return insured_num;
	}

	public void setInsured_num(String insured_num) {
		this.insured_num = insured_num;
	}

	public String getPremium_person() {
		return premium_person;
	}

	public void setPremium_person(String premium_person) {
		this.premium_person = premium_person;
	}

	public Long getYearReportId() {
		return yearReportId;
	}

	public void setYearReportId(Long yearReportId) {
		this.yearReportId = yearReportId;
	}
}
