package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;
import java.util.Date;

/**
 * 保安员证考试报名
 * @author  subh
 */
@Data
public class VPersoncertificate extends BaseModel {

	/**  */
	private static final long serialVersionUID = 1L;

	/**
	 * 姓名
	 */
	@ModelAnnotation(getName = "姓名",isGrid = true,column = "Name",width = "80px" )
	private String name;
    /**
     * 身份证号码
     */
    @ModelAnnotation(getName = "身份证号码",isGrid = true,column = "cardNumber",width = "160px")
    private String cardNumber;
	/**
	 * 联系电话
	 */
	@ModelAnnotation(getName="手机号",column = "phone",isGrid = true,width = "120px")
	private String phone;
    /**
     * 报名公司名称
     */
    @ModelAnnotation(getName = "报名公司名称",isGrid = true,column = "scName",width = "200px")
    private String scName;

	/**
	 * 是否自然人
	 */
	@ModelAnnotation(getName = "是否自然人",isGrid = true,column = "naturalPer",width = "80px")
	private String naturalPer;

	/**
	 * 培训机构名称
	 */
	@ModelAnnotation(getName="所属培训机构",column = "trainOrgName",isGrid = true,width = "200px")
	private String trainOrgName;
	/**
	 * 报名时间
	 */
	@ModelAnnotation(getName="报名时间",column = "createTime",isGrid = true,formatter = "toDateFormatter",width = "80px")
	private Date createTime;

	/**
	 * 修改时间
	 */
	private Date updateTime;

	/**
	 * 指纹卡号
	 */
	private String fingerprint;

	/**
	 * 指纹卡号状态
	 */
	private String fingercardState;

	/**
	 * 确认成绩状态
	 */
	private String confirmOrder;

	/**
	 * 考试时间
	 */
	@ModelAnnotation(getName="考试时间",column = "examStart",isGrid = true,formatter = "toDateFormatter",width = "80px")
	private Date examStart;
	/**
	 * 审批状态
	 * 001未提交002待审核003审批通过004审批不通过
	 */
	@ModelAnnotation(getName="审批状态",isGrid = true,column  = "approvalState",needTranslate = true,dictName = "approvalState",width = "80px")
	private String approvalState;
	/**
	 * 背景筛查 001未审查 003 审查通过 004审查不通过
	 */
	@ModelAnnotation(getName="背景筛查",column = "censorStatus",isGrid = true,needTranslate = true,dictName = "cerCensorStatus",width = "80px")
	private String censorStatus;
	/**
	 * 缴费状态 1已缴费 0 未缴费
	 */
	@ModelAnnotation(getName="缴费状态",column = "feeState",isGrid = true,needTranslate = true,dictName = "feeState",width = "80px")
	private String feeState;
	/**
	 * 材料核对状态
	 *
	 */
	@ModelAnnotation(getName="材料核对状态",isGrid = true,column = "checkState",needTranslate = true,dictName ="checkState",width = "80px")
	private String checkState;
	/**
	 * 考试安排状态：0未安排，1已安排，2已取消,3 已修改
	 */
	@ModelAnnotation(getName="考试安排",column = "examState",isGrid = true,needTranslate = true,dictName = "examState",width = "80px")
	private String examState;
	/**
	 * 笔试成绩
	 */
	@ModelAnnotation(getName="笔试成绩",isGrid = true,column = "writtenScore",width = "80px")
	private Integer writtenScore;

	/**
	 * 理论成绩
	 */
	private Integer operateScore;
	/**
	 * 考试状态 1通过0不通过
	 */
	@ModelAnnotation(getName="考试状态",column = "testState",isGrid = true,needTranslate = true,dictName = "testState",width = "80px")
	private String testState;

	@ModelAnnotation(getName="缴费公司",column = "payComName",isGrid = true,width = "180px")
	private String payComName;

	@ModelAnnotation(getName="理论学习进度",column = "learnRate",isGrid = true,width = "180px")
	private String learnRate;
}