package com.bcxin.ars.model.sb;

import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.Date;


/**
 * 保安协会等级评定对象
 *
 * @table sec_association_rating
 * @author lin
 * @date 2021-04-20
 */
@Data
public class SecAssociationRating extends BaseModel{

    private static final long serialVersionUID=1L;

    
    /**
     * 公司名称
     */
    private String comName;
                
    /**
     * 附件路径
     */
    private String filePath;
        
    /**
     * 审批状态 0 待受理 1已受理 2 驳回
     */
    private String approveState;
                
    /**
     * 审批时间
     */
    private Date approveTime;
        
    /**
     * 联系电话
     */
    private String phone;

    /**
     * 填写人
     */
    private String realName;

    /**
     * 用户id
     */
    private Long userId;
            
    /**
     * 审批用户id
     */
    private Long approveUserId;

    /**
     * 审批人
     */
    private String approveName;

    /**
     * 人员id
     */
    private Long perId;
    
    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
