package com.bcxin.ars.model.sb;


import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.model.task.ComContract;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 保安员等级证报名
 *
 * @author linqinglin
 * @Date 2020-01-15 20:10:55
 */
@Data
public class PersonGrade extends BaseModel {

    private static final long serialVersionUID = 1L;

    /**
     * 校验资格证是否满一年结果
     */
    private  String verifyCertification;

    /**
     * 公安机关id
     *
     */
    private Long orgId;
    /**
     * 人员id
     *
     */
    private Long personId;
    /**
     * 姓名
     *
     */
    @NotBlank(message = "姓名不能为空", groups = {ThirdPartyTrain.class})
    private String name;
    /**
     * 手机号
     *
     */
    @NotBlank(message = "手机号不能为空", groups = {ThirdPartyTrain.class})
    private String phone;
    /**
     * 身份证号
     *
     */
    @NotBlank(message = "身份证号不能为空", groups = {ThirdPartyTrain.class})
    private String idNum;
    /**
     * 报名时间
     *
     */
    private Date applyTime;
    /**
     * 培训机构id
     *
     */
    @NotNull(message = "培训机构id不能为空", groups = {ThirdPartyTrain.class})
    private Long trainId;
    /**
     * 培训机构
     *
     */
    @NotBlank(message = "培训机构不能为空", groups = {ThirdPartyTrain.class})
    private String trainName;
    /**
     * 选择培训机构时间（考试报名时间）
     *
     */
    private Date testTime;
    /**
     * 身份证正面
     *
     */
    @NotBlank(message = "身份证正面不能为空", groups = {ThirdPartyTrain.class})
    private String idFrontImg;
    /**
     * 身份证反面
     *
     */
    @NotBlank(message = "身份证反面不能为空", groups = {ThirdPartyTrain.class})
    private String idBackImg;
    /**
     * 头像
     *
     */
    private String headImg;
    /**
     * 公司id
     *
     */
    @NotNull(message = "公司id不能为空", groups = {ThirdPartyTrain.class})
    private Long comId;

    /**
     * 公司名称
     *
     */
    @NotBlank(message = "公司名称不能为空", groups = {ThirdPartyTrain.class})
    private String comName;

    /**
     * 等级 码表对应字段 appraisalGrade
     *
     */
    private String gradeLevel;
    /**
     * 学时进度
     *
     */
    private String period;
    /**
     * 学习状态
     *
     */
    private String periodStatus;
    /**
     * 实习状态
     *
     */
    private String practiceStatus;
    /**
     * 实习天数
     *
     */
    private Integer practiceDay;
    /**
     * 实习时长
     *
     */
    private Integer practiceHour;
    /**
     * 背景筛查状态
     * 码表对应字段 gradeCensorStatus
     */
    private String censorStatus;
    /**
     * 户籍地址
     *
     */
    @NotBlank(message = "户籍地址不能为空", groups = {ThirdPartyTrain.class})
    private String address;
    /**
     * 现住地址
     *
     */
    @NotBlank(message = "现住地址不能为空", groups = {ThirdPartyTrain.class})
    private String liveAddress;
    /**
     * 户籍类型
     *
     */
    @NotBlank(message = "户籍类型不能为空", groups = {ThirdPartyTrain.class})
    private String residentType;
    /**
     * 户籍所在地类型
     *
     */
    @NotBlank(message = "户籍所在地类型不能为空", groups = {ThirdPartyTrain.class})
    private String residentPlaceType;
    /**
     * 合同id
     *
     */
    private Long contractId;
    /**
     * 班级id
     *
     */
    private Long classId;
    /**
     * 结业考试结果 对应码表 testState
     *
     */
    private String testStateComplete;
    /**
     * 结业笔试成绩
     *
     */
    private String writtenScoreComplete;
    /**
     * 结业实操成绩
     *
     */
    private String operateScoreComplete;
    /**
     * 资格证号
     *
     */
    private String zgCerNo;
    /**
     * 资格证电子证
     *
     */
    private String zgCerUrl;
    /**
     * 资格证发证机关
     *
     */
    private String zgOrg;
    /**
     * 资格证培训单位
     *
     */
    private String zgTrainName;
    /**
     * 资格证发证日期
     *
     */
    private String zgIssueDate;
    /**
     * 缴费时间
     *
     */
    private Date payTime;
    /**
     * 缴费状态 对应码表 feeState
     *
     */
    private String payState;
    /**
     * 材料核对状态
     *
     */
    private String checkState;
    /**
     * 材料核对时间
     *
     */
    private Date checkDate;
    /**
     * 开班安排状态
     *
     */
    private String classState;
    /**
     * 鉴定笔试成绩
     *
     */
    private String writtenScore;
    /**
     * 鉴定实操成绩
     *
     */
    private String operateScore;
    /**
     * 鉴定考试结果 对应码表 testState
     *
     */
    private String testState;
    /**
     * 审批原因
     *
     */
    private String approvalReason;
    /**
     * 审批状态
     *
     */
    @ModelAnnotation(getName="审批状态",column = "approvalState",isExport = true,needTranslate = true,dictName = "applyStatus")
    private String approvalState;
    /**
     * 人员类型
     *
     */
    private String gradePersonType;
    /**
     * 户口簿户主页
     *
     */
    private String mainHomeUrl;
    /**
     * 户口簿本人页
     *
     */
    private String selfHomeUrl;
    /**
     * 普通高等学校报到证
     *
     */
    private String regCerUrl;
    /**
     * 普通高等学校毕业证书
     *
     */
    private String gradCerUrl;
    /**
     * 就业失业登记证
     *
     */
    private String empCerUrl;
    /**
     * 北京市农村劳动力转移就业证
     *
     */
    private String laborTranCerUrl;
    /**
     * 退役证或退伍证
     *
     */
    private String dischargeCerUrl;
    /**
     * 自主就业安置证明
     *
     */
    private String selfEmpCerUrl;
    /**
     * 复员证
     *
     */
    private String demobCerUrl;
    /**
     * 转业证
     *
     */
    private String conversionCerUrl;
    /**
     * 户籍所在区县人力社保部门开据的确认证明
     *
     */
    private String confirmCerUrl;

    /** 班级名称 */
    private String className;

    /** 开班时间 */
    private String classStartTime;

    /** 实操培训时间 */
    private String trainTime;

    /** 是否最新的 */
    private Boolean newest;

    /** 比对状态 */
    private String compareStatus;

    /** 比对不通过原因 */
    private String compareReason;

    /**
     * 发证日期
     *
     */
    private String cerDate;
    /**
     * 证书编号
     *
     */
    private String cerNo;
    /**
     * 是否补考 1是 0否
     */
    @NotBlank(message = "请指定补考状态", groups = {ThirdPartyTrain.class})
    private String makeUp;
    /**
     * 首次培训机构id
     *
     */
    private Long firstTrainId;
    /**
     * 首次培训机构
     *
     */
    private String firstTrainName;
    /**
     * 首次培训机构联系方式
     */
    private String firstTrainPhone;

    /**
     * 劳动合同起始时间
     */
    private Date contractStart;

    /**
     * 劳动合同结束时间
     */
    private Date contractEnd;


    /**
     * 合同
     */
    private ComContract contract;

    /**
     * 班级
     */
    private GradeClass gradeClass;




    /**
     * 结业证书信息
     */
    private GradeCompleteCer gradeCompleteCer;

    /**
     * 实习记录
     */
    private List<GradePractice> practiceList;


    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}