package com.bcxin.ars.model.sb;

import com.bcxin.ars.model.BaseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 
 * 订单信息表
 * 
 * @author zjh
 * @date 2018年8月24日 14:57:32
 * @注意事项 </b>
 * <b>
 */
@Data
public class OrderInfo extends BaseModel{

    /**  */
	private static final long serialVersionUID = 545418334393807629L;
    /** '创建人'*/
    private String createBy;
    /** '百课堂订单编号'*/
    private String bktOrderNo;
    /** '百课堂课程ID'*/
    private String bktCourseId;
    /** '百课堂课程名称'*/
    private String bktCourseName;
    /** ''百课堂培训机构id''*/
    private String bktOrgId;
    /** ''百课堂培训机构名称''*/
    private String bktOrgName;
    /** ''订单总额''*/
    private Double orderSumMoney;
    /** ''订单人数''*/
    private int orderPersonNum;
    /** '订单状态(见码表)'*/
    private String orderStatus;
    /** ''支付金额''*/
    private Double payMoney;
    /** ''支付成功时间''*/
    private Date paySuccessTime;
    /** '''支付方式(见码表)'''*/
    private String payMode;
    /** '支付者用户ID'''*/
    private Long payUserId;
    /** ''订单所在公司ID（自然人为空）''*/
    private Long companyId;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getPaySuccessTime() {
        return paySuccessTime;
    }
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setPaySuccessTime(Date paySuccessTime) {
        this.paySuccessTime = paySuccessTime;
    }
}