package com.bcxin.ars.model.msg;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/***
 * 公司消息信息表
 * @author  subh
 */
@Data
public class NewsnoticeCompany extends BaseModel {

    /**  */
    private static final long serialVersionUID = 1L;


    /** 发送人姓名 */
    @ModelAnnotation(getName="发送人姓名",column = "sendName")
    private String sendname;

    /** 发送人机构 */
    @ModelAnnotation(getName="发送人机构",column = "sendOrgName")
    private String sendorgname;

    /** 接收人ID */
    @ModelAnnotation(getName="接收人ID",column = "companyId")
    private Long companyId;

    /** 消息内容 */
    @ModelAnnotation(getName="消息内容",column = "newsContext")
    private String newscontext;

    /** 消息标题 */
    @ModelAnnotation(getName="消息标题",column = "newsTitle")
    private String newstitle;

    /** 阅读状态 */
    @ModelAnnotation(getName="阅读状态",column = "readstate")
    private String readstate;

    /** 公安消息ID */
    @ModelAnnotation(getName="公安消息ID",column = "newsnoticeid")
    private Long newsnoticeid;

    /** 公司名称*/
    @ModelAnnotation(getName="公司名称",column = "companyName")
    private String companyName;

    /** 公司LOGO */
    @ModelAnnotation(getName="公司LOGO",column = "companyLogo")
    private String companyLogo;

    /** 回复*/
    @ModelAnnotation(getName="回复内容",column = "replyContext")
    private String replyContext;
    /** 回复状态*/
    @ModelAnnotation(getName="回复状态",column = "replyState")
    private String replyState;
    /***
     * 回复附件是否为必填
     */
    @ModelAnnotation(getName="回复附件是否为必填",column = "replyAtt")
    private String replyAtt;
    /** 是否撤消 0未撤消1已撤消 */
    private String undoState;
    /**
     * 用户名
     */
    private String userName;

    /***
     * saas公司ID
     */
    private String comId;

    /***
     *
     * 附件列表
     */
    private Long[] sysAttachmentIds;
}