package com.bcxin.ars.model.gx;

import com.bcxin.ars.model.BaseModel;
import lombok.Data;
import java.util.Date;

/***
 * 广西证件许可数据推送给一平台
 * @author  subh
 */
@Data
public class CerPermit extends BaseModel {

    /**
     * 主键（关联sgs_form_2v的bsnum）
     */
    private String  bsnum;

    /**
     * 行政相对人（企业）名称（个体可以为空）
     */
    private String EntName;
    /**
     * 行政相对人 统一社会信用代码
     */
    private String UniSCID;
    /**
     * 组织机构代码
     */
    private String OrgCode;
    /**
     * 法定代表人, 企业、农专必填、个体非必填
      */
    private String LeRep;
    /**
     * 证件类型(申请人证件类型)
     */
    private String CerType;
    /**
     * 证件号码
     */
    private String CerNO;
    /**
     * 行政相对人（自然人）姓名
     */
    private String Name;
    /**
     * 事项名称
     */
    private String itemNo;
    /**
     * 事项编码
     */
    private String itmenNo;
    /**
     * 办件状态: 已办结, 未办结
     */
    private String state;
    /**
     * 数据来源单位名称
     */
    private String DataDept;
    /**
     * 数据来源单位统一社会信用代码
     */
    private String DataDeptUniSCID;
    /**
     * 数据汇聚上传单位名称
     */
    private String DataUpdateDept;
    /***
     * 备注
     */
    private String Remark;
    /**
     * 数据插入时间(自动更新, 请勿给值)
     */
    private Date create_time;
    /**
     * 备用字段1
     */
    private String back1;
    /**
     * 备用字段
     */
    private String back2;
    /**
     * 备用字段
     */
    private String back3;
    /**
     * 备用字段
     */
    private String back4;
    /***
     * 备用字段
     */
    private String back5;
    /**
     * 同步标识（默认0）： 0未同步， 1同步成功，2同步失败
     */
    private String flag;
}

