package com.bcxin.ars.model.epidemic;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.Date;
/***
 * 疫情防控信息表（公安）
 * @author subh
 */
@Data
public class EpidemicPolice extends Epidemic {
    @ModelAnnotation(getName="公司名称",isExport = true,isGrid = true,column  = "companyName",sign= SignType.LIKE,width = "200px")
    private String companyName;
    @ModelAnnotation(getName="填表人",isExport = true,column  = "filledBy",isGrid = true,width = "60px")
    private String filledBy;
    @ModelAnnotation(getName="填报人电话",isExport = true,column  = "filledByPhone",isGrid = true,width = "100px")
    private String filledByPhone;
    @ModelAnnotation(getName="填报时间",isExport = true,column  = "filledByTime",isGrid = true,width = "100px",formatter = "filledByTimeFn")
    private Date filledByTime;
    @ModelAnnotation(getName="驻勤点ID",column  = "taskId")
    private Long taskId;
    @ModelAnnotation(getName="驻勤点名称",isExport = true,column  = "taskName",isGrid = true,width = "100px")
    private String taskName ;
    @ModelAnnotation(getName="驻勤点详细地址",isExport = true,column  = "taskAddress")
    private String taskAddress;
    @ModelAnnotation(getName="监管机构",isExport = true,column  = "orgName",isGrid = true,width = "300px")
    private String orgName;
    @ModelAnnotation(getName="监管机构ID",isExport = true,column  = "orgId")
    private Long orgId;
    @ModelAnnotation(getName="所属区域",isExport = true,column  = "areaCode")
    private String areaCode;
    @ModelAnnotation(getName="保安员总人数",isExport = true,column  = "perNum",isGrid = true,width = "100px")
    private Long perNum;
    @ModelAnnotation(getName="已做核酸人数",isExport = true,column  = "nucleicCheckNum",isGrid = true,width = "100px")
    private Long nucleicCheckNum;
    @ModelAnnotation(getName="已做核酸未出结果人数",isExport = true,column  = "nucleicNum",isGrid = true,width = "150px")
    private Long nucleicNum;
    @ModelAnnotation(getName="未做核酸检测人数",isExport = true,column  = "unNucleicNum",isGrid = true,width = "150px")
    private Long unNucleicNum;
    @ModelAnnotation(getName="核酸检测呈阳性人数",isExport = true,column  = "nucleicPositiveNum",isGrid = true,width = "150px")
    private Long nucleicPositiveNum;
    @ModelAnnotation(getName="确诊人数",isExport = true,column  = "diagnosisNum",isGrid = true,width = "100px")
    private Long diagnosisNum;
    @ModelAnnotation(getName="政府集中隔离人数",isExport = true,column  = "quarantineGovNum",isGrid = true,width = "150px")
    private Long quarantineGovNum;
    @ModelAnnotation(getName="公司集中隔离人数",isExport = true,column  = "quarantineComNum",isGrid = true,width = "150px")
    private Long quarantineComNum;
    @ModelAnnotation(getName="驻勤点原地隔离人数",isExport = true,column  = "quarantineTaskNum",isGrid = true,width = "150px")
    private Long quarantineTaskNum;
    @ModelAnnotation(getName="隔离总人数",isExport = true,column  = "quarantineNum",isGrid = true,width = "100px")
    private Long quarantineNum;
    @ModelAnnotation(getName="核酸检测点",isExport = true,column  = "checkHospital",isGrid = false,needTranslate = true,dictName ="checkHospital",width = "100px" )
    private String checkHospital;
    @ModelAnnotation(getName="疫情驻勤点类型",isExport = true,column  = "epidemicTaskStationType",needTranslate = true,dictName ="epidemicTaskStationType",width = "100px" )
    private String epidemicTaskStationType;
    @ModelAnnotation(getName="街道ID",column  = "streetId")
    private Long streetId;
    @ModelAnnotation(getName="街道名称",isExport = true,column  = "streetName")
    private String streetName;
    @ModelAnnotation(getName="风险等级",isExport = true,column  = "riskLevel",needTranslate = true,dictName ="riskLevel" )
    private String riskLevel;
    @ModelAnnotation(getName="驻勤点类型",isExport = true,column  = "epidemicTaskType",needTranslate = true,dictName ="epidemicTaskType" )
    private String epidemicTaskType;
}
