package com.bcxin.ars.model.datasync;

import com.bcxin.ars.model.BaseModel;
import lombok.Data;


/**
 * 数据同步记录对象
 *
 * @table datasync_log
 * @author lin
 * @date 2020-12-07
 */
@Data
public class DataSyncLog extends BaseModel{

    private static final long serialVersionUID=1L;


    /**
     * 基础路径
     */
    private String basePath;
        
    /**
     * 文件路径
     */
    private String filePath;
    /**
     * 文件名
     */
    private String fileName;

    /**
     * 访问路径
     */
    private String url;
        
    /**
     * 类型 0业务数据 1客户上传附件 2警官上传附件
     */
    private String businessType;
        
    /**
     * 同步返回id
     */
    private String msgId;

    /**
     * 同步失败信息
     */
    private String errorInfo;

    /**
     * 同步状态 0未同步 1同步给ftp 2同步到内网
     */
    private String dataSyncState;
    
    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
