package com.bcxin.ars.model.conference;

import com.bcxin.ars.dto.conference.ComAccountZTree;
import com.bcxin.ars.dto.conference.ConferenceMemberDto;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.List;

/***
 * 会议信息
 * @author subh
 */
@Data
public class CloudConference extends BaseModel {

    /**  */
    private Long accountId;

    /** 会议主题 */
    private String theme;

    /**
     * 华为云会议id
     */
    private String meetId;

    /** 会议类型 */
    private String type;

    /** 是否预约 */
    private Boolean subscribe;

    /** 是否高清会议 */
    private Boolean hd;
    /****会议是否自动启动录制 **/
    private String autoRecord;
    /** 是否短信通知 */
    private Boolean notice;

    /** 会议时长（分钟） */
    private Integer duration;

    /** 会议开始时间 */
    private String startTime;

    /** 会议结束时间 */
    private String endTime;
    /** 会议状态 */
    private String state;
    /** 主席密码 */
    private String chairPwd;
    /** 来宾密码 */
    private String generalPwd;

    /** 会议角色 */
    private String conferenceRole;

    /** 会议加入密码 */
    private String confPasswd;

    /** 会议接入码 */
    private String accessNumber;

    /** 企业成员 */
    private String comMembers;

    /** 企业成员 */
    private List<ComAccountZTree> comAccounts;

    /** 公安成员id */
    private String policeMembers;

    /** 会议uuid */
    private String confUUID;

    /** 公安成员 */
    private List<ConferenceMember> policeAccounts;

    /**
     * 会议成员
     */
    private List<ConferenceMemberDto> attendees;
    /***
     * 是否有主席
     */
    private String chairman;
    /**
     *会议模式1个人会议2云会议模式
     * **/
    private String conferenceModel;
    /***
     * 会议ID类型
     */
    private String vmrID;
    /***
     * 云会议室名称
     */
    private String vmrName;
}