package com.bcxin.ars.model.certificate;


import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/**
 * 保安员等级证报名鉴定证书
 *
 * @author linqinglin
 * @Date 2020-02-04 10:50:12
 */
@Data
public class GradeAppraisalCer extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 等级证报名id
    * 
    */
    private Long personGradeId;
    /**
    * 保安员id
    *
    */
    private Long personId;
    /**
    * 发证日期
    * 
    */
    private String cerDate;
    /**
    * 姓名
    * 
    */
    private String name;
    /**
    * 身份证号
    * 
    */
    private String idNum;
    /**
    * 性别
    * 
    */
    private String gender;
    /**
    * 等级
    * 
    */
    private String gradeLevel;
    /**
    * 证书编号
    * 
    */
    private String cerNo;
    /**
    * 职业
    * 
    */
    private String profession;
    /**
    * 培训机构id
    * 
    */
    private Long trainId;
    /**
    * 培训机构
    * 
    */
    private String trainName;
    /**
    * 培训开始日期
    * 
    */
    private String trainStartDate;
    /**
    * 培训结束日期
    * 
    */
    private String trainEndDate;
    /**
    * 公司id
    * 
    */
    private Long comId;
    /**
    * 公司名称
    * 
    */
    private String comName;

    /**
     * 头像
     */
    private String headImg;

    /**
     * 二维码
     */
    private String qrCode;

 	
    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}