package com.bcxin.ars.model.certificate;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.Date;

/***
 * 资格证打印日志
 * @author subh
 */
@Data
public class CertificatePrintLog  extends BaseModel {
    /** 姓名 */
    @ModelAnnotation(getName="姓名",column = "name",isExport = true,sign= SignType.LIKE)
    private String name;
    /** 公民身份证号 */
    @ModelAnnotation(getName="公民身份证号",column = "idnum",isExport = true,sign= SignType.LIKE)
    private String idnum;
    /** 证书编号 */
    @ModelAnnotation(getName="证书编号",column = "securityCertificateNo",isExport = true,sign= SignType.LIKE)
    private String securityCertificateNo;
    /** 打印机构 */
    @ModelAnnotation(getName="打印机构",column = "printName",isExport = true,sign= SignType.LIKE)
    private String printName;
    /** 打印类型1打印2补证 */
    @ModelAnnotation(getName="打印类型",column = "printType",isExport = true,needTranslate = true,dictName = "printType")
    private String printType;
    /**
     * 打印时间
     */
    @ModelAnnotation(getName="打印时间",column = "create_time",isExport = true)
    private Date createTime;
    /***
     * 打印开始时间
     */
    @ModelAnnotation(getName="打印开始时间",column  = "create_time",sign = SignType.DATE_GREATER_EQUAL)
    private String startCreateTime;

    /***
     * 打印结束时间
     */
    @ModelAnnotation(getName="打印结束时间",column  = "create_time",sign = SignType.DATE_LESS_EQUAL)
    private String  endCreateTime;

    /** 打印机构ID */
    @ModelAnnotation(getName="打印机构ID",column = "trainOrgId")
    private Long trainOrgId;
}
