package com.bcxin.ars.model.approve;

import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.model.BaseModel;

import java.util.Date;

/**
 * 区域审批流程
 *
 * @author zhangye
 * @since 2018-01-19 14:15:24
 */
@ModelTableAnnotation(getName = "区域审批流程",tableName = "approve_area_process")
public class ApproveAreaProcess extends BaseModel {
    private static final long serialVersionUID = 1900296130L;


    /**
     * 生效时间
     */
    private Date effectTime;

    /**
     * 失效时间
     */
    private Date failureTime;

    /**
     * 审批配置状态
     */
    private String approveSetStatus;

    /**
     * 区域级别
     */
    private String regionLevel;

    /**
     * 单位所在区域ID
     */
    private String regionId;


    /**
     * 审批环节层级ID
     */
    private Long approveLinkLevelId;

    /**
     * 公安单位区域编码
     */
    private String policeCode;
    /**
     * 公安单位区域Id
     */
    private Long policeId;

    /**
     * 公安单位区域path
     */
    private String path;

    /**
     * 流程配置信息
     */
    private String processInfo;

    public String getProcessInfo() {
        return processInfo;
    }

    public void setProcessInfo(String processInfo) {
        this.processInfo = processInfo;
    }

    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public Date getFailureTime() {
        return failureTime;
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = failureTime;
    }

    public String getApproveSetStatus() {
        return approveSetStatus;
    }

    public void setApproveSetStatus(String approveSetStatus) {
        this.approveSetStatus = approveSetStatus;
    }

    public String getRegionLevel() {
        return regionLevel;
    }

    public void setRegionLevel(String regionLevel) {
        this.regionLevel = regionLevel;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public Long getApproveLinkLevelId() {
        return approveLinkLevelId;
    }

    public void setApproveLinkLevelId(Long approveLinkLevelId) {
        this.approveLinkLevelId = approveLinkLevelId;
    }

    public String getPoliceCode() {
        return policeCode;
    }

    public void setPoliceCode(String policeCode) {
        this.policeCode = policeCode;
    }

    public Long getPoliceId() {
        return policeId;
    }

    public void setPoliceId(Long policeId) {
        this.policeId = policeId;
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

}