package com.bcxin.ars.model.approve;

import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 区域审批流程明细人员
 *
 * @author zhangye
 * @since 2018-01-19 14:14:33
 */
public class ApproveAreaProDetailPer extends BaseModel {
    private static final long serialVersionUID = 1829702191L;
    /**
     * 区域审批流程明细ID
     */
    private Long approveAreaProDetailId;
    /**
     * 审批人员ID
     */

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long approvePerId;
    /**
     * 排序
     */
    private Integer seq;

    /**
     * 审批次数
     */
    private Integer approveTimes;

    /**
     * 工作状态
     */
    private String workStatus;


    public Long getApproveAreaProDetailId() {
        return approveAreaProDetailId;
    }

    public void setApproveAreaProDetailId(Long approveAreaProDetailId) {
        this.approveAreaProDetailId = approveAreaProDetailId;
    }

    public Long getApprovePerId() {
        return approvePerId;
    }

    public void setApprovePerId(Long approvePerId) {
        this.approvePerId = approvePerId;
    }

    public Integer getSeq() {
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Integer getApproveTimes() {
        return approveTimes;
    }

    public void setApproveTimes(Integer approveTimes) {
        this.approveTimes = approveTimes;
    }

    public String getWorkStatus() {
        return workStatus;
    }

    public void setWorkStatus(String workStatus) {
        this.workStatus = workStatus;
    }
}