package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.sb.UserBusinessType;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.lang.instrument.Instrumentation;
import java.util.*;

/**
 * 账户类
 * 
 * @author Ethan
 */
@ModelTableAnnotation(getName="用户账户基本信息",tableName="user")
public class User extends BaseModel {
	private static Instrumentation inst;
	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 数据区域
	 */
	@ModelAnnotation(getName="数据区域",column = "native_code")
	private Long nativeCode;
	@ModelAnnotation(getName="用户名",column = "username")
	private String username;

	@JsonIgnore
	@ModelAnnotation(getName="密码",column = "password")
	private String password;
	@ModelAnnotation(getName="真实姓名",column = "realname")
	private String realname;
	@ModelAnnotation(getName="手机",column = "phone")
	private String phone;

	/**
	 * 公司logo/用户头像/公安国徽
	 */
	@ModelAnnotation(getName="头像",column = "photo")
	private String photo;
	@ModelAnnotation(getName="是否初始化",column = "init")
	private Boolean init;

	// 是否民警
	@ModelAnnotation(getName="是否民警",column = "policeman")
	private Boolean policeman;

	// 是否可批复 表中不需要此字段 默认不能批复
	private Boolean replyRole = false;

	@ModelAnnotation(getName="平台角色",column = "platform")
	private Integer platform;
	private String sessionId;

	private List<Role> roleList;
	/**
	 * 登陆状态
	 */
	@ModelAnnotation(getName="登陆状态",column = "loginstate")
	private Integer loginstate;
	/**
	 * app标识
	 */
	@ModelAnnotation(getName="app标识",column = "registrationID")
	private String registrationID;

	/***
	 * app Token
	 */
	private String appToken;
	/***
	 * bkt Token
	 */
	private String bktToken;
	/***
	 * 设备名称
	 */
	private String deviceName;
	/***
	 * app版本号
	 */
	private String appVerion;
	/***
	 * 电池电量
	 */
	private String batteryLevel;

	/***
	 * 当前系统名称
	 */
	private String systemName;
	/***
	 * 当前系统版本号
	 */
	private String systemVersion;

	/**
	 * 设备id
	 */
	@ModelAnnotation(getName="设备id",column = "uuid")
	private String uuid;
	/**
	 * 身份证号码
	 */
	@ModelAnnotation(getName="身份证号码",column = "idnumber")
	private String idNumber;

	/**
	 * 警号
	 */
	@ModelAnnotation(getName="警号",column = "codeno")
	private String codeNo;

	/**
	 * 所属单位
	 */
	@ModelAnnotation(getName="所属单位",column = "orgname")
	private String orgName;

	/**
	 * 关联机构id
	 */
	@ModelAnnotation(getName="关联机构id",column = "orgid")
	private Long orgid;
	/**
	 * 角色
	 */
	@ModelAnnotation(getName="角色",column = "rolename")
	private String roleName;

	/**
	 * 登录次数
	 */
	@ModelAnnotation(getName="登录次数",column = "loginnum")
	private Integer loginNum;

	/**
	 * 最后登录时间
	 */
	private Date loginDate;

	/**
	 *  数据迁移关联的外网id
	 **/
	@ModelAnnotation(getName="外网id",column = "rawid")
	private Long rawid;

	/** 数据迁移关联的内网id **/
	@ModelAnnotation(getName="内网id ",column = "inrawid")
	private Long inrawid;

	private List<ModuleMenu> permissionList;

	private List<PoliceRole> roles;
	
	private List<UserRole> userRoles;

	/***
	 * 数据权限机构区域编码列表
	 */
	private List<Police> areasList;

	/***
	 * 业务支撑ID
	 */
	@ModelAnnotation(getName="业务支撑ID",column = "business_id")
	private String businessId;

	/***
	 * 百保联token
	 */
	private String token;
	/**
	 * 公司的userId
	 */
	private Long companyUserId;


    /***
     * 公共安全服务平台公司ID
     */
	private String comId;
	/***
	 * 培训平台地址
	 */
	private String trainURL;

	/***
	 * 培训平台旧地址
	 */
	private String oldTrainURL;

	/***
	 * 审批角色
	 */
	private Long approvalroleid;

	/**
	 * SaaS的sid
	 */
	private String sid;
	/***
	 * 机构
	 */
	private Police police;

	// 现金贷用户id
	@ModelAnnotation(getName="现金贷用户id",column = "xjdUserId")
	private String xjdUserId;

	// 第三方授权列表
	private List<ThirdAuthorization> thirdAuthorizationList = new ArrayList<ThirdAuthorization>();

	/**
	 * 业务类型
	 */
	private String businessTypes;

	private List<UserBusinessType> userBusinessTypeList = new ArrayList<UserBusinessType>();

	/***
	 * 百保盾H5服务器地址
	 */
	private String bbdH5Url;


	/***
	 * 市级编码
	 */
	private String cityAreaCode;
	/***
	 * 是否管理员
	 */
	@ModelAnnotation(getName="是否管理员",column = "isAdmin")
	private String isAdmin;

	/**
	 * 会议开通状态 1开通 0关闭
	 */
	@ModelAnnotation(getName="会议开通状态",column = "conferenceState")
	private String conferenceState;

	/**
	 * 云会议账号
	 */
	private ConferenceAccount conferenceAccount;

	/***
	 * 华为云会议信息AccessToken
	 */
	private String conferenceAccessToken;


	/**
	 * 华为帐号
	 */
	private String huaweiAccout;
	/***
	 * 华为密码
	 */
	private String huaweiPwd;



	//华为云用户ID
	private String HuaweiUserId;


	//华为云姓名
	private String HuaweiSipName;


	/**
	 * 城市名称
	 */
	private String cityName;

	/**
	 * 城市标识
	 */
	private String city;


	/**
	 * V1.0.9 add by zhangye 登陆步骤：协议1,认证2,重置密码3,初始化信息4
	 */

	private String flag = "0";

	/**
	 * V1.0.9 add by zhangye 跳过认证标识：false未跳过，true跳过
	 */
	@ModelAnnotation(getName="跳过认证标识",column = "isAuthMark")
	private boolean isAuthMark;


    /**
     * 人员态势
     */
    private String personDataURL;
    /**
     * 企业态势
     */
    private String companyDataURL;
    /**
     * 监管态势
     */
    private String policeDataURL;


	/***
	 *
	 */
	private String userinfo;

	/**
	 * 北京单点登录用户唯一id
	 */
	private String uniqueId;

	public String getUserinfo() {
		return userinfo;
	}

	public void setUserinfo(String userinfo) {
		this.userinfo = userinfo;
	}

	public String getPersonDataURL() {
        return personDataURL;
    }

    public void setPersonDataURL(String personDataURL) {
        this.personDataURL = personDataURL;
    }

    public String getCompanyDataURL() {
        return companyDataURL;
    }

    public void setCompanyDataURL(String companyDataURL) {
        this.companyDataURL = companyDataURL;
    }

    public String getPoliceDataURL() {
        return policeDataURL;
    }

    public void setPoliceDataURL(String policeDataURL) {
        this.policeDataURL = policeDataURL;
    }

    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public List<ThirdAuthorization> getThirdAuthorizationList() {
		return thirdAuthorizationList;
	}

	public List<UserBusinessType> getUserBusinessTypeList() {
		return userBusinessTypeList;
	}

	public void setUserBusinessTypeList(List<UserBusinessType> userBusinessTypeList) {
		this.userBusinessTypeList = userBusinessTypeList;
	}

	public void setThirdAuthorizationList(List<ThirdAuthorization> thirdAuthorizationList) {
		this.thirdAuthorizationList = thirdAuthorizationList;
	}
	public String getHuaweiAccout() {
		return huaweiAccout;
	}

	public String getCityName() {
		return cityName;
	}

	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	public void setHuaweiAccout(String huaweiAccout) {
		this.huaweiAccout = huaweiAccout;
	}

	public String getHuaweiPwd() {
		return huaweiPwd;
	}

	public void setHuaweiPwd(String huaweiPwd) {
		this.huaweiPwd = huaweiPwd;
	}

	public String getSid() {
		return sid;
	}

	public void setSid(String sid) {
		this.sid = sid;
	}

	public String getHuaweiUserId() {
		return HuaweiUserId;
	}

	public void setHuaweiUserId(String huaweiUserId) {
		HuaweiUserId = huaweiUserId;
	}

	public String getHuaweiSipName() {
		return HuaweiSipName;
	}

	public void setHuaweiSipName(String huaweiSipName) {
		HuaweiSipName = huaweiSipName;
	}




	public String getConferenceAccessToken() {
		return conferenceAccessToken;
	}

	public void setConferenceAccessToken(String conferenceAccessToken) {
		this.conferenceAccessToken = conferenceAccessToken;
	}

	public String getConferenceState() {
		return conferenceState;
	}

	public void setConferenceState(String conferenceState) {
		this.conferenceState = conferenceState;
	}

	public List<Police> getAreasList() {
		return areasList;
	}

	public void setAreasList(List<Police> areasList) {
		this.areasList = areasList;
	}



	public String getIsAdmin() {
		return isAdmin;
	}

	public void setIsAdmin(String isAdmin) {
		this.isAdmin = isAdmin;
	}

	public String getCityAreaCode() {
		return cityAreaCode;
	}

	public void setCityAreaCode(String cityAreaCode) {
		this.cityAreaCode = cityAreaCode;
	}

	public String getBusinessTypes() {
		return businessTypes;
	}

	public void setBusinessTypes(String businessTypes) {
		this.businessTypes = businessTypes;
	}
	public Police getPolice() {
		return police;
	}

	public void setPolice(Police police) {
		this.police = police;
	}

	public Long getApprovalroleid() {
		return approvalroleid;
	}

	public void setApprovalroleid(Long approvalroleid) {
		this.approvalroleid = approvalroleid;
	}

	public String getTrainURL() {
		return trainURL;
	}

	public void setTrainURL(String trainURL) {
		this.trainURL = trainURL;
	}

	private String companyUsername;

	public String getCompanyUsername() {
		return companyUsername;
	}

	public void setCompanyUsername(String companyUsername) {
		this.companyUsername = companyUsername;
	}

	public Long getCompanyUserId() {
		return companyUserId;
	}

	public void setCompanyUserId(Long companyUserId) {
		this.companyUserId = companyUserId;
	}

	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

/*	public List<Police> getAreaslist() {
		return areaslist;
	}

	public void setAreaslist(List<Police> areaslist) {
		this.areaslist = areaslist;
	}*/

	public List<ModuleMenu> getPermissionList() {
		return permissionList;
	}

	public void setPermissionList(List<ModuleMenu> permissionList) {
		this.permissionList = permissionList;
	}

	public String getDeviceName() {
		return deviceName;
	}

	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
	}

	public String getAppVerion() {
		return appVerion;
	}

	public void setAppVerion(String appVerion) {
		this.appVerion = appVerion;
	}

	public String getBatteryLevel() {
		return batteryLevel;
	}

	public void setBatteryLevel(String batteryLevel) {
		this.batteryLevel = batteryLevel;
	}

	public String getSystemName() {
		return systemName;
	}

	public void setSystemName(String systemName) {
		this.systemName = systemName;
	}

	public String getSystemVersion() {
		return systemVersion;
	}

	public void setSystemVersion(String systemVersion) {
		this.systemVersion = systemVersion;
	}

	public String getRegistrationID() {
		return registrationID;
	}

	public void setRegistrationID(String registrationID) {
		this.registrationID = registrationID;
	}

	public String getAppToken() {
		return appToken;
	}

	public void setAppToken(String appToken) {
		this.appToken = appToken;
	}

	// 用于显示页面菜单
	private List<Module> moduleList = new ArrayList<Module>();

	// 页面按钮操作权限(moduleCode:operationCode)
	private Map<String, Boolean> permission = new HashMap<String, Boolean>();

	private String messageCode;

	/**
	 * 初始化步骤(001 密码初始化 002 公司信息初始化 003 组织初始化 004 角色初始化
	 */
	@ModelAnnotation(getName="初始化步骤",column = "initstep")
	private String initstep;

	public Integer getLoginstate() {
		return loginstate;
	}

	public void setLoginstate(Integer loginstate) {
		this.loginstate = loginstate;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Boolean getInit() {
		return init;
	}

	public void setInit(Boolean init) {
		this.init = init;
	}

	public Integer getPlatform() {
		return platform;
	}

	public void setPlatform(Integer platform) {
		this.platform = platform;
	}

	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public String getRealname() {
		return realname;
	}

	public void setRealname(String realname) {
		this.realname = realname;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getPhoto() {
		return photo;
	}

	public void setPhoto(String photo) {
		this.photo = photo;
	}

	public List<Module> getModuleList() {
		return moduleList;
	}

	public void setModuleList(List<Module> moduleList) {
		this.moduleList = moduleList;
	}

	public Map<String, Boolean> getPermission() {
		return permission;
	}

	public void setPermission(Map<String, Boolean> permission) {
		this.permission = permission;
	}

	public String getMessageCode() {
		return messageCode;
	}

	public void setMessageCode(String messageCode) {
		this.messageCode = messageCode;
	}

	public String getIdNumber() {
		return idNumber;
	}

	public void setIdNumber(String idNumber) {
		this.idNumber = idNumber;
	}

	public String getCodeNo() {
		return codeNo;
	}

	public void setCodeNo(String codeNo) {
		this.codeNo = codeNo;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getOrgid() {
		return orgid;
	}

	public void setOrgid(Long orgid) {
		this.orgid = orgid;
	}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	public Integer getLoginNum() {
		return loginNum;
	}

	public void setLoginNum(Integer loginNum) {
		this.loginNum = loginNum;
	}

	public Date getLoginDate() {
		return loginDate;
	}

	public void setLoginDate(Date loginDate) {
		this.loginDate = loginDate;
	}

	@Override
	public String toString() {
		return "User [id="+super.getId()+",username=" + username + ", realname=" + realname + ", phone=" + phone + ", photo=" + photo
				+ ", init=" + init + ", platform=" + platform + ", orgName=" + orgName + ", initstep=" + initstep + "]";
	}

	public List<PoliceRole> getRoles() {
		return roles;
	}

	public void setRoles(List<PoliceRole> roles) {
		this.roles = roles;
	}

	public Long getRawid() {
		return rawid;
	}

	public void setRawid(Long rawid) {
		this.rawid = rawid;
	}

	public Long getInrawid() {
		return inrawid;
	}

	public void setInrawid(Long inrawid) {
		this.inrawid = inrawid;
	}

	public Boolean getPoliceman() {
		return policeman;
	}

	public void setPoliceman(Boolean policeman) {
		this.policeman = policeman;
	}

	public String getOldTrainURL() {
		return oldTrainURL;
	}

	public void setOldTrainURL(String oldTrainURL) {
		this.oldTrainURL = oldTrainURL;
	}

	public String getUuid() {
		return uuid;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	public String getInitstep() {
		return initstep;
	}

	public void setInitstep(String initstep) {
		this.initstep = initstep;
	}

	public String getXjdUserId() {
		return xjdUserId;
	}

	public void setXjdUserId(String xjdUserId) {
		this.xjdUserId = xjdUserId;
	}

	public List<Role> getRoleList() {
		return roleList;
	}

	public void setRoleList(List<Role> roleList) {
		this.roleList = roleList;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public boolean isAuthMark() {
		return isAuthMark;
	}

	public void setAuthMark(boolean isAuthMark) {
		this.isAuthMark = isAuthMark;
	}

	public String getBbdH5Url() {
		return bbdH5Url;
	}

	public void setBbdH5Url(String bbdH5Url) {
		this.bbdH5Url = bbdH5Url;
	}

	public List<UserRole> getUserRoles() {
		return userRoles;
	}

	public void setUserRoles(List<UserRole> userRoles) {
		this.userRoles = userRoles;
	}

	public String getBktToken() {
		return bktToken;
	}

	public void setBktToken(String bktToken) {
		this.bktToken = bktToken;
	}

	public Boolean getReplyRole() {
		return replyRole;
	}

	public void setReplyRole(Boolean replyRole) {
		this.replyRole = replyRole;
	}

    public String getComId() {
        return comId;
    }

    public void setComId(String comId) {
        this.comId = comId;
    }

    @Override
	public boolean equals (Object o){
		return super.equals(o);
	}

	@Override
	public int hashCode() {
		return super.hashCode();
	}

	public ConferenceAccount getConferenceAccount() {
		return conferenceAccount;
	}

	public void setConferenceAccount(ConferenceAccount conferenceAccount) {
		this.conferenceAccount = conferenceAccount;
	}

	public static long sizeOf(Object obj){
		        return inst.getObjectSize(obj);
	   }

	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}
}
