package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

/**
 * 保安员好人好事要闻
 *
 * @author harve
 */
@Data
@ModelTableAnnotation(extra=false)
public class SecurityGoodThing extends BaseModel {

    private static final long serialVersionUID = -1181608430428373429L;

    /**
     * 公司ID
     */
    @ModelAnnotation(getName="公司ID",column = "user_id")
    private Long userid;
    
    /**
     * 人员ID
     */
    @ModelAnnotation(getName="人员ID",column = "person_id")
    private Long personId;

    /**
     * 姓名
     */
    @ModelAnnotation(getName="姓名",column = "name",isExport = true,sign = SignType.LIKE)
    private String name;

    /**
     * 身份证号
     */
    @ModelAnnotation(getName="身份证号",column = "id_number",isExport = true,sign = SignType.LIKE)
    private String idNumber;
    
    /**
     * 手机号
     */
    @ModelAnnotation(getName="手机号",column = "phone",isExport = true,sign = SignType.LIKE)
    private String phone;

    /**
     * 部门名称
     */
    @ModelAnnotation(getName="部门名称",column = "department",isExport = true)
    private String department;
    /**
     * 公司名称
     */
    @ModelAnnotation(getName="公司名称",column = "company_name",isExport = true,sign = SignType.LIKE)
    private String companyName;

    /**
     * 日期
     */
    @ModelAnnotation(getName="日期",column = "good_thing_date",isExport = true)
    private String goodThingDate;

    /**
     * 内容
     */
    @ModelAnnotation(getName="内容",column = "content",isExport = true)
    private String content;

    /**
     * 备注
     */
    @ModelAnnotation(getName="备注",column = "remark",isExport = true)
    private String remark;

    /**
     * 与saas对接的主键
     */
    private Long goodDeedsId;

    private SecurityPerson person;
    
    private String eduName;
    
    private String nativeName;

    /**
     * 好人好事类型
     */
    @ModelAnnotation(getName="好人好事类型",column = "goodDeedsType",isExport = true,needTranslate = true,dictName = "goodDeedsType")
    private String goodDeedsType;

}
