package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Date;

/**
 * 保安培训机构信息
 * @author Ethan
 */
public class SecurityConfesscompany extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column  = "user_id")
	private Long userid;

	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}

	/**
	 * 培训单位编码
	 */
	@ModelAnnotation(getName="单位编码",isExport = true,column  = "pxdwbm",defaultColumn = true)
	private String pxdwbm;

	/**
	 * 培训单位名称
	 */
	@ModelAnnotation(getName="单位名称",isExport = true,column  = "pxdwmc",defaultColumn = true)
	private String pxdwmc;

	/**
	 * 注册地省市县（区）
	 */
	@ModelAnnotation(getName="注册地省市县（区）",isExport = true,column  = "zcssx")
	private String zcssx;

	/**
	 * 注册地址
	 */
	@ModelAnnotation(getName="注册地址",isExport = true,column  = "zcdz",defaultColumn = true)
	private String zcdz;

	/**
	 * 主要负责人姓名
	 */
	@ModelAnnotation(getName="主要负责人姓名",isExport = true,column  = "lxrxm",defaultColumn = true)
	private String lxrxm;

	/**
	 * 主要负责人联系电话
	 */
	@ModelAnnotation(getName="主要负责人联系电话",isExport = true,column  = "lxdh",defaultColumn = true)
	private String lxdh;


	/**
	 * 校长（院长）姓名
	 */
	@ModelAnnotation(getName=" 校长姓名",isExport = true,column  = "xzxm",defaultColumn = true)
	private String xzxm;
	/**
	 * 校长（院长）公民身份号码
	 */
	@ModelAnnotation(getName="校长公民身份号码",isExport = true,column  = "xzsfzh",defaultColumn = true)
	private String xzsfzh;

	/**
	 * 校长（院长）联系电话
	 */
	@ModelAnnotation(getName="校长（院长）联系电话",isExport = true,column  = "xzdh")
	private String xzdh;

	/**
	 * 注册资金
	 * @return
	 */
	@ModelAnnotation(getName="注册资金",isExport = true,column  = "zczj")
	private Double zczj;


	/**
	 * 保安培训许可证编码
	 */
	@ModelAnnotation(getName="保安培训许可证编码",isExport = true,column  = "pxxkz")
	private String pxxkz;

	/**
	 * 保安培训许可证发证机关编码
	 */
	@ModelAnnotation(getName="保安培训许可证发证机关编码",isExport = true,column  = "fzjgbm")
	private String fzjgbm;

	/**
	 * 保安培训许可证发证机关名称
	 */
	@ModelAnnotation(getName="保安培训许可证发证机关名称",isExport = true,column  = "fajgmc")
	private String fajgmc;

	/**
	 * 保安培训许可证颁发日期
	 */
	@ModelAnnotation(getName="保安培训许可证颁发日期",isExport = true,column  = "xkzbfrq")
	private Date xkzbfrq;

	/**
	 * 保安培训许可证吊销机关
	 */
	@ModelAnnotation(getName="保安培训许可证吊销机关",isExport = true,column  = "xkzdxjg")
	private String xkzdxjg;

	/**
	 * 保安培训许可证吊销日期
	 */
	@ModelAnnotation(getName="保安培训许可证吊销日期",isExport = true,column  = "xkzdxrq")
	private Date xkzdxrq;

	/**
	 * 保安培训许可证吊销原因
	 */
	@ModelAnnotation(getName="保安培训许可证吊销原因",isExport = true,column  = "xkzdxyy")
	private String xkzdxyy;

	/**
	 * 保安培训机构类别
	 */
	@ModelAnnotation(getName="保安培训机构类别",isExport = true,column  = "pxdwlb")
	private String pxdwlb;

	/**
	 * 备注1
	 */
	@ModelAnnotation(getName="备注1",isExport = true,column  = "bz1")
	private String bz1;


	/**
	 * 备注2
	 */
	@ModelAnnotation(getName="备注2",isExport = true,column  = "bz2")
	private String bz2;


	/**
	 * 备注3
	 */
	@ModelAnnotation(getName="备注3",isExport = true,column  = "bz3")
	private String bz3;

	/**所在地省代码**/
	@ModelAnnotation(getName="所在地省代码",isExport = true,column  = "province")
	private String province;

	/**所在地市代码**/
	@ModelAnnotation(getName="所在地市代码",isExport = true,column  = "city")
	private String city;

	/**所在地县（区）代码**/
	@ModelAnnotation(getName="所在地县（区）代码",isExport = true,column  = "district")
	private String district;

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getDistrict() {
		return district;
	}

	public void setDistrict(String district) {
		this.district = district;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getPxdwbm() {
		return pxdwbm;
	}

	public void setPxdwbm(String pxdwbm) {
		this.pxdwbm = pxdwbm;
	}

	public String getPxdwmc() {
		return pxdwmc;
	}

	public void setPxdwmc(String pxdwmc) {
		this.pxdwmc = pxdwmc;
	}

	public String getZcssx() {
		return zcssx;
	}

	public void setZcssx(String zcssx) {
		this.zcssx = zcssx;
	}

	public String getZcdz() {
		return zcdz;
	}

	public void setZcdz(String zcdz) {
		this.zcdz = zcdz;
	}

	public String getLxrxm() {
		return lxrxm;
	}

	public void setLxrxm(String lxrxm) {
		this.lxrxm = lxrxm;
	}

	public String getLxdh() {
		return lxdh;
	}

	public void setLxdh(String lxdh) {
		this.lxdh = lxdh;
	}

	public String getXzsfzh() {
		return xzsfzh;
	}

	public void setXzsfzh(String xzsfzh) {
		this.xzsfzh = xzsfzh;
	}

	public String getXzxm() {
		return xzxm;
	}

	public void setXzxm(String xzxm) {
		this.xzxm = xzxm;
	}

	public String getXzdh() {
		return xzdh;
	}

	public void setXzdh(String xzdh) {
		this.xzdh = xzdh;
	}

	public Double getZczj() {
		return zczj;
	}

	public void setZczj(Double zczj) {
		this.zczj = zczj;
	}

	public String getPxxkz() {
		return pxxkz;
	}

	public void setPxxkz(String pxxkz) {
		this.pxxkz = pxxkz;
	}

	public String getFzjgbm() {
		return fzjgbm;
	}

	public void setFzjgbm(String fzjgbm) {
		this.fzjgbm = fzjgbm;
	}

	public String getFajgmc() {
		return fajgmc;
	}

	public void setFajgmc(String fajgmc) {
		this.fajgmc = fajgmc;
	}


	public String getXkzdxjg() {
		return xkzdxjg;
	}

	public void setXkzdxjg(String xkzdxjg) {
		this.xkzdxjg = xkzdxjg;
	}

	public Date getXkzbfrq() {
		return xkzbfrq;
	}

	public void setXkzbfrq(Date xkzbfrq) {
		this.xkzbfrq = xkzbfrq;
	}

	public Date getXkzdxrq() {
		return xkzdxrq;
	}

	public void setXkzdxrq(Date xkzdxrq) {
		this.xkzdxrq = xkzdxrq;
	}

	public String getXkzdxyy() {
		return xkzdxyy;
	}

	public void setXkzdxyy(String xkzdxyy) {
		this.xkzdxyy = xkzdxyy;
	}

	public String getPxdwlb() {
		return pxdwlb;
	}

	public void setPxdwlb(String pxdwlb) {
		this.pxdwlb = pxdwlb;
	}

	public String getBz1() {
		return bz1;
	}

	public void setBz1(String bz1) {
		this.bz1 = bz1;
	}

	public String getBz2() {
		return bz2;
	}

	public void setBz2(String bz2) {
		this.bz2 = bz2;
	}

	public String getBz3() {
		return bz3;
	}

	public void setBz3(String bz3) {
		this.bz3 = bz3;
	}

	@Override
	public String toString() {
		return "SecurityConfesscompany{" +
				"user=" + user +
				", userid=" + userid +
				", pxdwbm='" + pxdwbm + '\'' +
				", pxdwmc='" + pxdwmc + '\'' +
				", zcssx='" + zcssx + '\'' +
				", zcdz='" + zcdz + '\'' +
				", lxrxm='" + lxrxm + '\'' +
				", lxdh='" + lxdh + '\'' +
				", xzsfzh='" + xzsfzh + '\'' +
				", xzxm='" + xzxm + '\'' +
				", xzdh='" + xzdh + '\'' +
				", zczj=" + zczj +
				", pxxkz='" + pxxkz + '\'' +
				", fzjgbm='" + fzjgbm + '\'' +
				", fajgmc='" + fajgmc + '\'' +
				", xkzbfrq='" + xkzbfrq + '\'' +
				", xkzdxjg='" + xkzdxjg + '\'' +
				", xkzdxrq='" + xkzdxrq + '\'' +
				", xkzdxyy='" + xkzdxyy + '\'' +
				", pxdwlb='" + pxdwlb + '\'' +
				", bz1='" + bz1 + '\'' +
				", bz2='" + bz2 + '\'' +
				", bz3='" + bz3 + '\'' +
				'}';
	}
}
