package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 保安奖励信息
 * @author Ethan
 */
public class SbReward extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column = "user_id")
	private Long userid;

	/**
	 * 姓名
	 */
	@ModelAnnotation(getName="姓名",column = "name")
	private String name;

	/**
	 * 身份证号
	 */
	@ModelAnnotation(getName="身份证号",column = "idnumber")
	private String idNumber;

	/**
	 * 员工编号
	 */
	@ModelAnnotation(getName="员工编号",column = "employeeid")
	private String employeeid;

	/**
	 * 部门名称
	 */
	@ModelAnnotation(getName="部门名称",column = "departname")
	private String departname;

	/**
	 * 奖励日期
	 */
	@ModelAnnotation(getName="奖励日期",column = "rewarddate")
	private String rewardDate;

	/**
	 * 奖励内容
	 */
	@ModelAnnotation(getName="奖励内容",column = "rewardcontext")
	private String rewardContext;

	/**
	 * 奖励原因
	 */
	@ModelAnnotation(getName="奖励原因",column = "rewardreason")
	private String rewardReason;

	/**
	 * 备注
	 */
	@ModelAnnotation(getName="备注",column = "remarks")
	private String remarks;

	/**
	 * 奖励单位
	 */
	@ModelAnnotation(getName="奖励单位",column = "rewardcompany")
	private String rewardCompany;

	/**
	 * 是否公安机关作出
	 * @return
	 */
	@ModelAnnotation(getName="是否公安机关作出",column = "isbypolice")
	private String isByPolice;

	/**
	 * 与saas对接的ID
	 */
	private Long awardId;

	public Long getAwardId() {
		return awardId;
	}

	public void setAwardId(Long awardId) {
		this.awardId = awardId;
	}

	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}
	
	public String getIsByPolice() {
		return isByPolice;
	}

	public void setIsByPolice(String isByPolice) {
		this.isByPolice = isByPolice;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getIdNumber() {
		return idNumber;
	}

	public void setIdNumber(String idNumber) {
		this.idNumber = idNumber;
	}

	public String getEmployeeid() {
		return employeeid;
	}

	public void setEmployeeid(String employeeid) {
		this.employeeid = employeeid;
	}

	public String getDepartname() {
		return departname;
	}

	public void setDepartname(String departname) {
		this.departname = departname;
	}

	public String getRewardDate() {
		return rewardDate;
	}

	public void setRewardDate(String rewardDate) {
		this.rewardDate = rewardDate;
	}

	public String getRewardContext() {
		return rewardContext;
	}

	public void setRewardContext(String rewardContext) {
		this.rewardContext = rewardContext;
	}

	public String getRewardReason() {
		return rewardReason;
	}

	public void setRewardReason(String rewardReason) {
		this.rewardReason = rewardReason;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getRewardCompany() {
		return rewardCompany;
	}

	public void setRewardCompany(String rewardCompany) {
		this.rewardCompany = rewardCompany;
	}

	@Override
	public String toString() {
		return "SbReward{" +
				"user=" + user +
				", userid=" + userid +
				", name='" + name + '\'' +
				", idNumber='" + idNumber + '\'' +
				", employeeid='" + employeeid + '\'' +
				", departname='" + departname + '\'' +
				", rewardDate='" + rewardDate + '\'' +
				", rewardContext='" + rewardContext + '\'' +
				", rewardReason='" + rewardReason + '\'' +
				", remarks='" + remarks + '\'' +
				", rewardCompany='" + rewardCompany + '\'' +
				'}';
	}
}
