package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 跨区经营情况
 * @author Ethan
 */
public class SbBusinessManagement extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column = "user_id")
	private Long userid;

	/**
	 * 跨区经营市县
	 */
	@ModelAnnotation(getName="跨区经营省",column = "cross_city_business_province")
	private String crossCityBusinessProvince;

	@ModelAnnotation(getName="跨区经营市",column = "cross_city_business_city")
	private String crossCityBusinessCity;

	@ModelAnnotation(getName="跨区经营区",column = "cross_city_business_county")
	private String crossCityBusinessCounty;

	/**
	 * 跨区经营地址
	 */
	@ModelAnnotation(getName="跨区经营地址",column = "cross_city_address")
	private String crossCityAddress;

	/**
	 * 保安服务类型
	 */
	@ModelAnnotation(getName="保安服务类型",column = "security_services_type")
	private String securityServicesType;

	/**
	 * 负责人
	 */
	@ModelAnnotation(getName="负责人",column = "principal")
	private String principal;

	/**
	 * 负责人电话
	 */
	@ModelAnnotation(getName="负责人电话",column = "principal_phone")
	private String principalPhone;

	/**
	 * 负责人身份证号
	 */
	@ModelAnnotation(getName="负责人身份证号",column = "principal_id")
	private String principalId;

	/**
	 *  备案公安机关名称
	 */
	@ModelAnnotation(getName="备案公安机关名称",column = "filing_authority_name")
	private String filingAuthorityName;

	/**
	 *  备案日期
	 */
	@ModelAnnotation(getName="备案日期",column = "filing_authority_date")
	private String filingAuthorityDate;

	/**
	 * 经营起始时间
	 */
	@ModelAnnotation(getName="经营起始时间",column = "business_start_time")
	private String businessStartTime;

	/**
	 * 职业技能等级
	 */
	@ModelAnnotation(getName="职业技能等级",column = "job_level")
	private String jobLevel;

	/**
	 * 学历
	 */
	@ModelAnnotation(getName="学历",column = "education")
	private String education;

	/**
	 * 职务
	 */
	@ModelAnnotation(getName="职务",column = "job_name")
	private String jobName;

	/**
	 * 联系方式
	 */
	@ModelAnnotation(getName="联系方式",column = "tel")
	private String tel;

	/**
	 *安保范围
	 */
	@ModelAnnotation(getName="安保范围",column = "security_scope")
	private String securityScope;

	/**
	 * 其他保安服务范围名称(保安范围为其他则此列必填)
	 */
	@ModelAnnotation(getName="其他保安服务范围名称",column = "otherSecScopeType")
	private String otherSecScopeType;

	public String getOtherSecScopeType() {
		return otherSecScopeType;
	}

	public void setOtherSecScopeType(String otherSecScopeType) {
		this.otherSecScopeType = otherSecScopeType;
	}


	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}
	
	public String getCrossCityBusinessCounty() {
		return crossCityBusinessCounty;
	}

	public void setCrossCityBusinessCounty(String crossCityBusinessCounty) {
		this.crossCityBusinessCounty = crossCityBusinessCounty;
	}

	public String getSecurityScope() {
		return securityScope;
	}

	public void setSecurityScope(String securityScope) {
		this.securityScope = securityScope;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getCrossCityBusinessProvince() {
		return crossCityBusinessProvince;
	}

	public void setCrossCityBusinessProvince(String crossCityBusinessProvince) {
		this.crossCityBusinessProvince = crossCityBusinessProvince;
	}

	public String getCrossCityBusinessCity() {
		return crossCityBusinessCity;
	}

	public void setCrossCityBusinessCity(String crossCityBusinessCity) {
		this.crossCityBusinessCity = crossCityBusinessCity;
	}

	public String getCrossCitBusinessyCounty() {
		return crossCityBusinessCounty;
	}

	public void setCrossCityCounty(String crossCityBusinessCounty) {
		this.crossCityBusinessCounty = crossCityBusinessCounty;
	}

	public String getCrossCityAddress() {
		return crossCityAddress;
	}

	public void setCrossCityAddress(String crossCityAddress) {
		this.crossCityAddress = crossCityAddress;
	}

	public String getSecurityServicesType() {
		return securityServicesType;
	}

	public void setSecurityServicesType(String securityServicesType) {
		this.securityServicesType = securityServicesType;
	}

	public String getPrincipal() {
		return principal;
	}

	public void setPrincipal(String principal) {
		this.principal = principal;
	}

	public String getPrincipalPhone() {
		return principalPhone;
	}

	public void setPrincipalPhone(String principalPhone) {
		this.principalPhone = principalPhone;
	}

	public String getPrincipalId() {
		return principalId;
	}

	public void setPrincipalId(String principalId) {
		this.principalId = principalId;
	}

	public String getFilingAuthorityName() {
		return filingAuthorityName;
	}

	public void setFilingAuthorityName(String filingAuthorityName) {
		this.filingAuthorityName = filingAuthorityName;
	}

	public String getFilingAuthorityDate() {
		return filingAuthorityDate;
	}

	public void setFilingAuthorityDate(String filingAuthorityDate) {
		this.filingAuthorityDate = filingAuthorityDate;
	}

	public String getBusinessStartTime() {
		return businessStartTime;
	}

	public void setBusinessStartTime(String businessStartTime) {
		this.businessStartTime = businessStartTime;
	}

	public String getJobLevel() {
		return jobLevel;
	}

	public void setJobLevel(String jobLevel) {
		this.jobLevel = jobLevel;
	}

	public String getEducation() {
		return education;
	}

	public void setEducation(String education) {
		this.education = education;
	}

	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	public String getTel() {
		return tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	@Override
	public String toString() {
		return "SbBusinessManagement{" +
				"user=" + user +
				", userid=" + userid +
				", crossCityBusinessProvince='" + crossCityBusinessProvince + '\'' +
				", crossCityBusinessCity='" + crossCityBusinessCity + '\'' +
				", crossCityBusinessCounty='" + crossCityBusinessCounty + '\'' +
				", crossCityAddress='" + crossCityAddress + '\'' +
				", securityServicesType='" + securityServicesType + '\'' +
				", principal='" + principal + '\'' +
				", principalPhone='" + principalPhone + '\'' +
				", principalId='" + principalId + '\'' +
				", filingAuthorityName='" + filingAuthorityName + '\'' +
				", filingAuthorityDate='" + filingAuthorityDate + '\'' +
				", businessStartTime='" + businessStartTime + '\'' +
				", jobLevel='" + jobLevel + '\'' +
				", education='" + education + '\'' +
				", jobName='" + jobName + '\'' +
				", tel='" + tel + '\'' +
				'}';
	}
}
