package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 安保公司角色
 * @author Ethan
 */
public class Role extends BaseModel {

	private static final long serialVersionUID = 3992550218660360309L;

	/**
	 * 区域编号
	 */
	@ModelAnnotation(getName="区域编号",column = "native_code")
	private Long nativeCode;
	
	/**
	 * 所属公司
	 */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private SecurityCompany company;
	
	/**
	 * 角色名称
	 */
	@ModelAnnotation(getName="角色名称",column = "name")
	private String name;
	

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public SecurityCompany getCompany() {
		return company;
	}

	public void setCompany(SecurityCompany company) {
		this.company = company;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
}
