package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.Date;

/***
 * 问题人员信息表
 */
@Data
@ModelTableAnnotation(areaCodeFilter="1")
public class ProblemPerson extends BaseModel {
    /**  */
    private static final long serialVersionUID = 1L;

    /** 姓名 */
    @ModelAnnotation(getName="姓名",isExport = true,column  = "name",sign = SignType.LIKE)
    private String name;

    /** 身份证号 */
    @ModelAnnotation(getName="身份证号",isExport = true,column  = "idnumber",sign = SignType.LIKE)
    private String idnumber;

    /** 手机号 */
    @ModelAnnotation(getName="手机号",isExport = true,column  = "phone",sign = SignType.LIKE)
    private String phone;

    /** 性别 */
    @ModelAnnotation(getName="性别",isExport = true,column  = "sex")
    private String sex;


    /** 问题类型 */
    @ModelAnnotation(getName="问题类型",isExport = true,column  = "problemtype",sign = SignType.LIKE)
    private String problemtype;

    /** 对外意见 */
    @ModelAnnotation(getName="对外意见",isExport = true,column  = "suggestion")
    private String suggestion;

    /** 内部建议 */
    @ModelAnnotation(getName="内部建议",isExport = true,column  = "reson")
    private String reson;

    /** 处理状态 */
    @ModelAnnotation(getName="处理状态",isExport = true,column  = "dispose",needTranslate = true,dictName = "dispose")
    private String dispose;

    /** 公司名称 */
    @ModelAnnotation(getName="公司名称",isExport = true,column  = "companyname",sign = SignType.LIKE)
    private String companyname;



    /** 企业处理状态 */
    @ModelAnnotation(getName="企业处理状态",isExport = true,column  = "disposeCompany",needTranslate = true,dictName = "dispose")
    private String disposeCompany;

    /** 企业处理意见 */
    @ModelAnnotation(getName="企业处理意见",isExport = true,column  = "companyReson")
    private String companyReson;

    /** 人员id */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long personid;

    /** 公司id */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long companyid;


    /**监管机构ID**/
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long orgId;


    /***监管机构名称***/
    @ModelAnnotation(getName="监管机构名称",isExport = true,column  = "orgName")
    private String orgName;


    /** 是否人口信息错误 */
    @ModelAnnotation(getName="是否人口信息错误",isExport = false,column  = "cz")
    private Boolean cz;

    /** 是否吸毒人员 */
    @ModelAnnotation(getName="是否吸毒人员",isExport = false,column  = "xd")
    private Boolean xd;

    /** 是否在逃人员 */
    @ModelAnnotation(getName="是否在逃人员",isExport = false,column  = "zt")
    private Boolean zt;

    /** 是否违法犯罪人员 */
    @ModelAnnotation(getName="是否违法犯罪人员",isExport = false,column  = "wf")
    private Boolean wf;





    /**就职状态**/
    @ModelAnnotation(getName="就职状态",isExport = true,column  = "incumbencyStatus",needTranslate = true,dictName = "incumbencyStatus")
    private String incumbencyStatus;

    /***所属区域代码***/
    @ModelAnnotation(getName = "所属区域代码",column = "areaCode",defaultColumn=true,sign = SignType.LIKE)
    private String areaCode;

    /**
     * 公安建议处理措施
     */
    @ModelAnnotation(getName="公安建议处理措施",isExport = true,column  = "inform",needTranslate = true,dictName = "inform")
    private String inform;
    /**
     * 是否已读
     */
    private Boolean readed;
    /**
     * SAAS消息id
     */
    private String newId;

    /**
     * 企业处理时间
     */
    @ModelAnnotation(getName="企业处理时间",isExport = true,column  = "comHandleDate")
    private Date comHandleDate;

    /**
     * 公安机关处理时间
     */
    @ModelAnnotation(getName="公安机关处理时间",isExport = true,column  = "handleDate")
    private Date handleDate;

    /**
     * 比对时间
     */
    @ModelAnnotation(getName="比对时间",isExport = true,column  = "comparisonDate")
    private Date comparisonDate;

    /**
     * 处理人
     */
    @ModelAnnotation(getName="处理人",isExport = false,column  = "handler")
    private String handler;

    /**
     * 处理人机构
     */
    @ModelAnnotation(getName="处理人机构",isExport = false,column  = "handlerOrg")
    private String handlerOrg;

    /**
     * 对比开始时间
     */
    @ModelAnnotation(getName="对比开始时间",column  = "create_time",sign = SignType.DATE_GREATER_EQUAL)
    private String startContrastDate;
    /***
     * 对比结束时间
     */
    @ModelAnnotation(getName="对比结束时间",column  = "create_time",sign = SignType.DATE_LESS_EQUAL)
    private String endContrastDate;
    /**
     * 公安处理开始时间
     */
    @ModelAnnotation(getName="公安处理开始时间",column  = "handleDate",sign = SignType.DATE_GREATER_EQUAL)
    private String startHandleDate;
    /***
     * 公安处理结束时间
     */
    @ModelAnnotation(getName="公安处理结束时间",column  = "handleDate",sign = SignType.DATE_LESS_EQUAL)
    private String endHandleDate;
    /****
     *超过几天未处理
     */
    @ModelAnnotation(getName="超过几天未处理",column  = "create_time",sign = SignType.OUTDAY)
    private String outDayUnHandle;
    /***
     * 抓获状态
     */
    @ModelAnnotation(getName="抓获状态",column  = "catchState",isExport = true,needTranslate = true,dictName = "catchState")
    private String catchState;
    /***
     * 人员类型1信息有误2在逃3前科（重点人员）
     */
    @ModelAnnotation(getName="人员类型",column  = "personType")
    private String personType;


    /***
     * 实时姓名
     */
    private String realname;
    /***
     * 实时身份证号
     */
    private String realIdNumber;
    /**
     * 勿删
     * @param o
     * @return
     */
    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    /**
     * 勿删
     * @return
     */
    @Override
    public int hashCode() {
        return super.hashCode();
    }
}