package com.bcxin.ars.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 权限
 * @author Ethan
 */
@Data
public class Permission implements Serializable {

	private static final long serialVersionUID = -3850487309757813772L;

	private Long id;
	
	private Long nativeCode;
	
	private Long roleid;

	private Long operationid;
	
	/** 角色类型 1 - role,2 - policerole **/
	private String roletype;

	private Module module;
	
	private Operation operation;


	/**
	 * 模块的名称
	 */
	private String moduleCode;
	/***
	 * 功能的名称
	 */
	private String opreationCode;


	/**
	* 父模块ID
	* */
    private Long modulePId;

	public String getModuleCode() {
		return moduleCode;
	}

	public void setModuleCode(String moduleCode) {
		this.moduleCode = moduleCode;
	}

	public String getOpreationCode() {
		return opreationCode;
	}

	public void setOpreationCode(String opreationCode) {
		this.opreationCode = opreationCode;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Long getOperationid() {
		return operationid;
	}

	public void setOperationid(Long operationid) {
		this.operationid = operationid;
	}

//	public Role getRole() {
//		return role;
//	}
//
//	public void setRole(Role role) {
//		this.role = role;
//	}

	public Module getModule() {
		return module;
	}

	public void setModule(Module module) {
		this.module = module;
	}

	public Operation getOperation() {
		return operation;
	}

	public void setOperation(Operation operation) {
		this.operation = operation;
	}
	
	public String getPermissionCode() {
		return this.getModuleCode() + ":" + this.getOpreationCode();
	}

	public Long getRoleid() {
		return roleid;
	}

	public void setRoleid(Long roleid) {
		this.roleid = roleid;
	}

	public String getRoletype() {
		return roletype;
	}

	public void setRoletype(String roletype) {
		this.roletype = roletype;
	}
	
}
