package com.bcxin.ars.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 组织架构
 * @author llc
 */
@Data
public class OrganizationDto extends BaseModel {

	private static final long serialVersionUID = 622167690260043356L;

	/**
	 * 单位ID
	 */
	private Long companyId;
	
	/**
	 * 组织名称
	 */
	private String orgName;


	/**
	 * 上级组织ID
	 */
	private Long parentId;


	/***
	 * 组织机构人员(当前部门:不包含下属部门)
	 */
	private Integer pesonNum;


	/***
	 * 组织机构人员合计（包含下属部门）
	 */
	private Integer personSum;
	/***
	 *
	 */
	private List<Long> ids;


    /**
     * 上级组织
     */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private OrganizationDto parent;


    /**
     * 下级组织
     */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
    private List<OrganizationDto> childrens = new ArrayList<OrganizationDto>();

	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<SecurityPerson> personList;


	/**
	 * 勿删
	 * @param o
	 * @return
	 */
	@Override
	public boolean equals (Object o){
		boolean retVal = false;
		if (o != null && o.getClass().equals(this.getClass())) {
			BaseModel that = (BaseModel) o;
			if (that.getId() != null && this.getId() != null){
				if (that.getId().intValue() == this.getId().intValue()) {
					retVal = true;
				}
			}
		}
		return retVal;
	}

	/**
	 * 勿删
	 * @return
	 */
	@Override
	public int hashCode() {
		return getId().hashCode();
	}
}
