package com.bcxin.ars.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;

/**
 * 省市县
 * @author Ethan
 */
public class Native implements Serializable{

	private static final long serialVersionUID = -1280029273417914047L;
	
	/**
	 * 省市县编号
	 */
	private Long code;
	
	/**
	 * 地区名
	 */
	private String nativeName;
	
	/**
	 * 上级区域编号
	 */
	private Long parentCode;
	
	/**
	 * 上级区域对象
	 */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private Native parent;
	
	/**
	 * 下级行政区域
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<Native> children = new ArrayList<Native>();

	public Long getCode() {
		return code;
	}

	public void setCode(Long code) {
		this.code = code;
	}

	public String getNativeName() {
		return nativeName;
	}

	public void setNativeName(String nativeName) {
		this.nativeName = nativeName;
	}

	public Long getParentCode() {
		return parentCode;
	}

	public void setParentCode(Long parentCode) {
		this.parentCode = parentCode;
	}
	
	public Native getParent() {
		return parent;
	}

	public void setParent(Native parent) {
		this.parent = parent;
	}

	public List<Native> getChildren() {
		return children;
	}

	public void setChildren(List<Native> children) {
		this.children = children;
	}
	
}
