package com.bcxin.ars.export;

import com.bcxin.ars.enums.SignType;

import java.util.Map;

/**
 * @author linqinglin
 * @date 2020/04/07 0007 9:20
 */
public class IdCardNativeExportWhereStrategy implements ExportWhereStrategy {

    @Override
    public String spliceWhereStr(SignType signType, Map<String,String> columnMap, Map<Object, Object> searchParams, Object key) {
        String nativePlace = (String)searchParams.get(key);
        if (nativePlace.endsWith("0000")) {
            nativePlace = nativePlace.substring(0, 2) + "________________";
        } else if (nativePlace.endsWith("00")) {
            //市、设置机构类型 市级2
            nativePlace = nativePlace.substring(0, 4) + "______________";
        }
        StringBuilder columnStr = new StringBuilder(" and  ")
                .append(columnMap.get(key))
                .append(" like ")
                .append(" '%")
                .append(nativePlace)
                .append("%'");
        return columnStr.toString();
    }
}
