package com.bcxin.ars.dto.task;

import java.util.ArrayList;
import java.util.List;

import com.bcxin.ars.model.task.TaskStatus;
import com.bcxin.ars.model.task.TaskType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

public class TaskDto {

	/**任务id**/
	private Long taskid;
	
	/**任务名**/
	private String name;
	
	/**任务类型**/
	@JsonIgnoreProperties(value={"handler"})
	private TaskType taskType;
	
	/**任务地点*/
	private String address;
		
	/** 地点经度 */
	private String longitude;
	
	/** 地点纬度*/
	private String latitude;
	
	/**半径范围*/
	private Integer scope;
	
	/** 任务明细*/
	private String detail;

	/**任务状态*/
	@JsonIgnoreProperties(value={"handler"})
	private TaskStatus taskStatus;
	
	/**接受状态 ：0-未接受（即新任务）、1-已接受、2-已拒绝、3已完成、4超时*/
	private String acceptStatus;
	
	/**开始日期*/
	private String startDate;

	/**结束日期*/
	private String endDate;
	
	/**任务创建日期*/
	@JsonIgnore
	private String createTime;
	
	/**人员列表*/
	private List<TaskPersonDto> persons = new ArrayList<TaskPersonDto>();
	
	/**子任务列表*/
	private List<TaskFeedBackDto> feedbacks = new ArrayList<TaskFeedBackDto>();

	/**最近的子任务*/
	private TaskFeedBackDto nearfeedback;
	
	/**需要人数(紧急任务需要)*/
	private Integer neednum;
	
	private Boolean repeat;
	
	/**当前任务状态*/
	private String currentTaskStatus;//1:正在执行,2:已完成,3:已结束,4:新任务,5:即将进行,6已拒绝，7.已过期
	
	/**是否紧急任务*/
	private Boolean urgent;
	
	public Long getTaskid() {
		return taskid;
	}

	public void setTaskid(Long taskid) {
		this.taskid = taskid;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public TaskType getTaskType() {
		return taskType;
	}

	public void setTaskType(TaskType taskType) {
		this.taskType = taskType;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public Integer getScope() {
		return scope;
	}

	public void setScope(Integer scope) {
		this.scope = scope;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public TaskStatus getTaskStatus() {
		return taskStatus;
	}

	public void setTaskStatus(TaskStatus taskStatus) {
		this.taskStatus = taskStatus;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public List<TaskPersonDto> getPersons() {
		return persons;
	}

	public void setPersons(List<TaskPersonDto> persons) {
		this.persons = persons;
	}

	public List<TaskFeedBackDto> getFeedbacks() {
		return feedbacks;
	}

	public void setFeedbacks(List<TaskFeedBackDto> feedbacks) {
		this.feedbacks = feedbacks;
	}

	public String getAcceptStatus() {
		return acceptStatus;
	}

	public void setAcceptStatus(String acceptStatus) {
		this.acceptStatus = acceptStatus;
	}

	public Integer getNeednum() {
		return neednum;
	}

	public void setNeednum(Integer neednum) {
		this.neednum = neednum;
	}

	public TaskFeedBackDto getNearfeedback() {
		return nearfeedback;
	}

	public void setNearfeedback(TaskFeedBackDto nearfeedback) {
		this.nearfeedback = nearfeedback;
	}

	public Boolean isRepeat() {
		return repeat;
	}

	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}

	public String getCreateTime() {
		return createTime;
	}

	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	public String getCurrentTaskStatus() {
		return currentTaskStatus;
	}

	public void setCurrentTaskStatus(String currentTaskStatus) {
		this.currentTaskStatus = currentTaskStatus;
	}

	public Boolean getUrgent() {
		return urgent;
	}

	public void setUrgent(Boolean urgent) {
		this.urgent = urgent;
	}
	
}
