package com.bcxin.ars.dto.task;

import com.bcxin.ars.model.task.ComShift;
import com.bcxin.ars.model.task.ComShiftRule;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/03/27 0027 8:58
 */
@Data
public class ComShiftDto extends ComShift {

    /**
     * 旧班次ID
     *
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long oldShiftId;

    /**
     * 班次规则
     */
    private List<ComShiftRule> comShiftRuleList;
}
