package com.bcxin.ars.dto.subsidy;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.subsidy.SubsidyOffline;
import lombok.Data;

import java.util.Date;


/**
 * 线下补贴审批单查询dto
 *
 * @author lin
 * @date 2020-11-12
 */
@Data
public class SubsidyOfflinePageSearchDto extends SearchDto<SubsidyOffline> {
    private static final long serialVersionUID = 1L;

    
    /**
     * 主键id
     */
    private Long id;
    
    /**
     * 是否可用
     */
    private Boolean active;
    
    /**
     * 更新标识
     */
    private Boolean updateflag;
    
    /**
     * 创建时间
     */
    private Date createTime;
    
    /**
     * 修改时间
     */
    private Date updateTime;
    
    /**
     * 操作者
     */
    private String updateBy;
    
    /**
     * 区域编码
     */
    private String areaCode;
    
    /**
     * 公安机构id
     */
    private Long orgId;
    
    /**
     * 操作者id
     */
    private Long userId;
    
    /**
     * 补贴审批表附件id
     */
    private Long appAttachmentId;
    
    /**
     * 审批结果附件id
     */
    private Long resultAttachmentId;
    
    /**
     * 审批状态
     */
    private String offApprovalState;
    
    /**
     * 批次数
     */
    private Integer batchNum;
    
    /**
     * 补贴金额
     */
    private String subsidyMoney;
    
    /**
     * 申请机构数
     */
    private Integer comNum;
    
    /**
     * 申请补贴周期
     */
    private String cycle;
    
    /**
     * 补贴审批表附件
     */
    private String approvePath;
    
    /**
     * 审批结果附件
     */
    private String resultPath;
    
    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;
}
