package com.bcxin.ars.dto.sb;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.sb.Personcertificate;
import lombok.Data;

@Data
public class SearchPersonCertificateDto extends SearchDto<Personcertificate> {
    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * 姓名
     */
    private String name;
    /**
     * 身份证号码
     */
    private String cardNumber;
    /**
     * 联系电话
     */
    private String phone;
    /**
     * 报名公司名称
     */
    private String scName;

    /**
     * 缴费公司名称
     */
    private String payComName;
    /**
     * 所属培训机构
     */
    private String trainOrgName;
    /**
     * 所属公安机构
     */
    private String orgTree;
    private Long orgId;
    private String orgAreaCode;
    private String orgType;


    /**
     * 考试开始时间
     */
    private String examStart;
    /**
     * 考试结束时间
     */
    private String examEnd;

    /**
     * 报名开始日期时间
     */
    private String startTime;
    /**
     * 报名结束日期时间
     */
    private String endTime;
    /**
     * 审批状态
     * 001未提交002待审核003审批通过004审批不通过
     */
    private String approvalState;
    /**
     * 背景筛查 001未审查 003 审查通过 004审查不通过
     */
    private String censorStatus;
    /**
     * 缴费状态 1已缴费 0 未缴费
     */
    private String feeState;

    /**
     * 考试状态 1通过0不通过
     */
    private String testState;

    /**
     * 指纹录入状态 0 待录入1已入库2已录入
     */
    private String fingercardState;


    /**
     * 是否为自然人     1 是  0不是
     */
    private String naturalPer;

    /**
     * 理论学习状态
     */
    private Integer learnRate;

    /**
     * 材料核对状态
     */
    private String checkState;

    /**
     * 是否在职
     */
    private String isOnWork;

}
