package com.bcxin.ars.dto.sb;

import com.bcxin.ars.model.sb.Family;
import com.bcxin.ars.model.sb.Personworkexperience;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.List;

/**
 * @author linqinglin
 * @date 2019/08/29 0029 17:33
 */
@Data
public class SAASPersonCerDto {

    /**
     * 主键
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /**
     * 人员ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long personid;

    /**
     * 姓名
     */
    private String name;
    /**
     * 性别
     */
    private String sex;
    /**
     * 出生年月
     */
    private String brith;

    /**
     * 文化程度
     */
    private String culture;
    /**
     * 联系电话
     */
    private String phone;

    /**
     * 身份证号码
     */
    private String cardnumber;
    /**
     * 户籍地址
     */
    private String address;

    /**
     * 身高
     */
    private String hight;

    /**
     * 现住地址
     */
    private String nowAddress;

    /***
     * 头像
     */
    private String imglogo;

    /**
     * 所在地省市县（区）
     **/
    private String szss;
    /**
     * 所在地省代码
     **/
    private String province;
    /**
     * 所在地市代码
     **/
    private String city;
    /**
     * 所在地县（区）代码
     **/
    private String district;

    /**
     * 身份证正面
     **/
    private String idCardFront;
    /**
     * 身份证反面
     **/
    private String idCardReverse;
    /**
     * 县级以上医院出具的体检证明
     **/
    private String healthExamination;
    /**
     * 初中以上学历证明原件
     **/
    private String eduPhoto;

    /**
     * 派出所ID
     */
    private Long orgid;

    /**
     * 所属公司名称
     */
    private String companyName;


    /**
     * 家庭成员
     */
    List<Family> familyList;

    /**
     * 工作经历
     */
    List<Personworkexperience> workexperienceList;

    /**
     * 审批状态 002 待审批 003 审批通过 004 审批不通过 005 审批中
     */
    private String approvalStatus;
    /**
     * 审批人
     */
    private String approvalperson;
    /**
     * 审批时间
     */
    private String approvaldate;
    /**
     * 审批原因
     */
    private String approvalreason;

    /***
     * 背景筛查状态
     */
    private String backgroundScreenStatus;

    /***
     * 缴费状态
     */
    private String payStatus;

    /***
     * 是否安排考试
     */
    private String isArrangeExam;

    /***
     * 考试结果
     */
    private String examResult;

    /**
     * 笔试成绩
     */
    private String writtenScore;
    /**
     * 实操成绩
     */
    private String operateScore;
    /**
     * 总成绩
     */
    private String sumScore;
    /***
     * 提交时间
     */
    private String submitTime;

    /**
     * 民族
     */
    private String nation;

}
