package com.bcxin.ars.dto.sb;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.List;


/**
 *机构管理搜索类
 * @author Ethan
 */
@Data
public class PoliceSearchDto extends SearchDto<Police> {


	/**
	 * 主键id
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long id;
	/**
	 * 是否导出
	 * @return
	 */
	public boolean isExport;

	/**
	 * 区域编码数组
	 */
	private Long[] policeIdArrs;

	/**user表里面的orgid
	 * orgid
	 */
	private Long orgid;

	private Long roleId;

	/**
	 * 用户ID
	 */
	private Long userid;
	/**
	 * 机构名称
	 */
	private String orgname;
	/**
	 * 机构类型 1 省级  2市级 3 县级 4 派出所
	 */
	private String orgtype;

	/**
	 *联系电话
	 */
	private String phone;

	/**
	 * 联系人
	 */
	private String contact;

	/**
	 * 所属区域
	 */
	private String area;
	/**
	 * 上级机构
	 * @return
	 */
	private Long parentorg;



	/**
	 * 搜索条件
	 * @return
	 */
	private String searchCondition;

	/**
	 * 区域搜索条件
	 */
	private String searchOrgname;

	/**
	 * 判断机构名称是否唯一
	 */
	private String addOrgname;

	/**
	 * 是否展开
	 */
	private boolean expanded=false;


	private String orgIds;//组织结构（可多个用,隔开）

	private  String path;

	/**
	 * 显示到哪一级
	 */
	private  String maxOrgType;
	/***
	 * 数据权限机构区域编码列表
	 */
	private List<Police> areasList;

	private  String sysarea;

}
