package com.bcxin.ars.dto.sb;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.gx.RequestDto;
import com.google.common.collect.Lists;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * sb_legalchange
 * 法人变更
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年5月20日 下午12:36:31
 * @注意事项 </b>
 * <b>
 */
@Data
public class LegalchangeDto implements Serializable {

    private static final long serialVersionUID = 2220082166930076300L;

    /**
     * 公司名称
     */
	private String comName;

	/**
	 * 原法人姓名
	 */
	private String legalname;

	/**
	 * 原法人性别
	 */
	private String legalsex;

	/**
	 * 原法人证件号码
	 */
	private String legalcardnumber;

    /**
     * 原法人任职时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date officetime;
	/**
	 * 拟定法人名称
	 */
    private String ndlegalname;

	/**
	 * 拟定法人性别
	 */
    private String ndlegalsex;

	/**
	 * 拟定出生年月
	 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date ndlegalbrith;

	/**
	 * 拟定法人文化程度
	 */
    private String ndlegalculture;

	/**
	 * 拟定法人证件类型
	 */
    private String ndlegalcardtype;

	/**
	 * 拟定法人证件号码
	 */
    private String ndlegalcardnum;

	/**
	 * 拟定法人国籍
	 */
    private String ndlegalnationality;

	/**
	 * 拟定法人手机号码
	 */
    private String ndlegalphone;

	/**
	 * 拟定法人户籍所在地
	 */
    private String ndlegaladdress;

	/**
	 * 拟定法人实际地址
	 */
    private String ndleaglsjaddress;

    /**
     * 附件
     */
    private String templateRar;
	/**
	 * 数据来源
	 */
	private String dataSource;

    List<WorkexperienceDto> workexperienceList;

	public static void main(String[] args) {
		List<WorkexperienceDto> workexperienceList = new ArrayList<>();
		WorkexperienceDto workexperienceDto = new WorkexperienceDto();
		workexperienceDto.setCompanyname("帝国公司");
		workexperienceDto.setPost("经理");
		workexperienceDto.setStartdate(new Date());
		workexperienceDto.setEnddate(new Date());
		workexperienceList.add(workexperienceDto);


		LegalchangeDto legalchangeDto = new LegalchangeDto();
		legalchangeDto.setComName("万乐明广西服务公司20200701");
		legalchangeDto.setLegalname("万乐明");
		legalchangeDto.setLegalsex("1");
		legalchangeDto.setLegalcardnumber("110101198001078887X");
		legalchangeDto.setOfficetime(new Date());
		legalchangeDto.setNdlegalname("万乐明2");
		legalchangeDto.setNdlegalsex("1");
		legalchangeDto.setNdlegalbrith(new Date());
		legalchangeDto.setNdlegalculture("1");
		legalchangeDto.setNdlegalcardtype("1");
		legalchangeDto.setNdlegalcardnum("110101198001078887X");
		legalchangeDto.setNdlegalnationality("中国");
		legalchangeDto.setNdlegalphone("15750701070");
		legalchangeDto.setNdlegaladdress("拟定法人户籍地址");
		legalchangeDto.setNdleaglsjaddress("拟定法人居住地址");
		legalchangeDto.setWorkexperienceList(workexperienceList);

		RequestDto requestDto = new RequestDto();
		requestDto.setSdata(legalchangeDto);
		requestDto.setSdono("1111222");

		System.out.println(JSON.toJSONString(requestDto));

	}
}