package com.bcxin.ars.dto.sb;

import com.bcxin.ars.dto.SearchDto;
import lombok.Data;

import java.io.Serializable;

@Data
public class ExamSearchDto extends SearchDto<ExamDto> implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -2863386662597954955L;

    /**
     * 科目ID
     */
    private String subjectID;

    /**
     * 准考证 即身份证号
     */
    private String ticket;

    /**
     * 姓名
     */
    private String fullname;

    /**
     * 公司
     */
    private String company;

    /**
     * 区域
     */
    private String areaCode;
    /**
     * 区域名称
     */
    private String areaName;

    /***
     * 查询
     */
    private String queryAreaCode;

    /***
     * 开始日期
     */
    private String startTime;

    /***
     * 结束日期
     */
    private String endTime;

    /**
     * 区域名称
     */
    private String areaCodeName;
    /***
     * 是否缴费
     */
    private String isPay;

    /**
     * 考点ID
     */
    private Long examID;

    /**
     * 培训机构ID
     */
    private String trainOrgID;

    /**
     * 培训机构名称
     */
    private String trainOrgName;

    /**
     * 课程学习进度起始值
     */
    private Integer learnRate;

    /**
     * 补考次数
     */
    private Integer makeUpCount;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 考试名称
     */
    private String examName;

    /**
     * 是否补考
     */
    private String isMakeUp;

    /**
     * 补考状态  003补考通过 004补考未通过
     */
    private String makeUpstate;


    /***
     * 是否需要流程
     */
    private String needActivity;


    /***
     * 是否需要指纹
     */
    private String fingerprint;

    /**
     * 人员筛选类型
     * 0代表初次考试 ；1代表补考人员
     */
    private String personFilterType;

}
